// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.storage.models;

import com.azure.core.annotation.Immutable;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.storage.fluent.models.StorageAccountInner;
import java.io.IOException;
import java.util.List;

/**
 * The response from the List Storage Accounts operation.
 */
@Immutable
public final class StorageAccountListResult implements JsonSerializable<StorageAccountListResult> {
    /*
     * Gets the list of storage accounts and their properties.
     */
    private List<StorageAccountInner> value;

    /*
     * Request URL that can be used to query next page of storage accounts. Returned when total number of requested
     * storage accounts exceed maximum page size.
     */
    private String nextLink;

    /**
     * Creates an instance of StorageAccountListResult class.
     */
    public StorageAccountListResult() {
    }

    /**
     * Get the value property: Gets the list of storage accounts and their properties.
     * 
     * @return the value value.
     */
    public List<StorageAccountInner> value() {
        return this.value;
    }

    /**
     * Get the nextLink property: Request URL that can be used to query next page of storage accounts. Returned when
     * total number of requested storage accounts exceed maximum page size.
     * 
     * @return the nextLink value.
     */
    public String nextLink() {
        return this.nextLink;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (value() != null) {
            value().forEach(e -> e.validate());
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of StorageAccountListResult from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of StorageAccountListResult if the JsonReader was pointing to an instance of it, or null if
     * it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the StorageAccountListResult.
     */
    public static StorageAccountListResult fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            StorageAccountListResult deserializedStorageAccountListResult = new StorageAccountListResult();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("value".equals(fieldName)) {
                    List<StorageAccountInner> value
                        = reader.readArray(reader1 -> StorageAccountInner.fromJson(reader1));
                    deserializedStorageAccountListResult.value = value;
                } else if ("nextLink".equals(fieldName)) {
                    deserializedStorageAccountListResult.nextLink = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedStorageAccountListResult;
        });
    }
}
