// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.storage.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * The storage task assignment report.
 */
@Fluent
public final class StorageTaskAssignmentUpdateReport implements JsonSerializable<StorageTaskAssignmentUpdateReport> {
    /*
     * The prefix of the storage task assignment report
     */
    private String prefix;

    /**
     * Creates an instance of StorageTaskAssignmentUpdateReport class.
     */
    public StorageTaskAssignmentUpdateReport() {
    }

    /**
     * Get the prefix property: The prefix of the storage task assignment report.
     * 
     * @return the prefix value.
     */
    public String prefix() {
        return this.prefix;
    }

    /**
     * Set the prefix property: The prefix of the storage task assignment report.
     * 
     * @param prefix the prefix value to set.
     * @return the StorageTaskAssignmentUpdateReport object itself.
     */
    public StorageTaskAssignmentUpdateReport withPrefix(String prefix) {
        this.prefix = prefix;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("prefix", this.prefix);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of StorageTaskAssignmentUpdateReport from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of StorageTaskAssignmentUpdateReport if the JsonReader was pointing to an instance of it, or
     * null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the StorageTaskAssignmentUpdateReport.
     */
    public static StorageTaskAssignmentUpdateReport fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            StorageTaskAssignmentUpdateReport deserializedStorageTaskAssignmentUpdateReport
                = new StorageTaskAssignmentUpdateReport();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("prefix".equals(fieldName)) {
                    deserializedStorageTaskAssignmentUpdateReport.prefix = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedStorageTaskAssignmentUpdateReport;
        });
    }
}
