/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.storage.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.storage.models.BlobInventoryPolicyDefinition;
import java.io.IOException;

public final class BlobInventoryPolicyRule
implements JsonSerializable<BlobInventoryPolicyRule> {
    private boolean enabled;
    private String name;
    private String destination;
    private BlobInventoryPolicyDefinition definition;
    private static final ClientLogger LOGGER = new ClientLogger(BlobInventoryPolicyRule.class);

    public boolean enabled() {
        return this.enabled;
    }

    public BlobInventoryPolicyRule withEnabled(boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    public String name() {
        return this.name;
    }

    public BlobInventoryPolicyRule withName(String name) {
        this.name = name;
        return this;
    }

    public String destination() {
        return this.destination;
    }

    public BlobInventoryPolicyRule withDestination(String destination) {
        this.destination = destination;
        return this;
    }

    public BlobInventoryPolicyDefinition definition() {
        return this.definition;
    }

    public BlobInventoryPolicyRule withDefinition(BlobInventoryPolicyDefinition definition) {
        this.definition = definition;
        return this;
    }

    public void validate() {
        if (this.name() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property name in model BlobInventoryPolicyRule"));
        }
        if (this.destination() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property destination in model BlobInventoryPolicyRule"));
        }
        if (this.definition() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property definition in model BlobInventoryPolicyRule"));
        }
        this.definition().validate();
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeBooleanField("enabled", this.enabled);
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeStringField("destination", this.destination);
        jsonWriter.writeJsonField("definition", (JsonSerializable)this.definition);
        return jsonWriter.writeEndObject();
    }

    public static BlobInventoryPolicyRule fromJson(JsonReader jsonReader) throws IOException {
        return (BlobInventoryPolicyRule)jsonReader.readObject(reader -> {
            BlobInventoryPolicyRule deserializedBlobInventoryPolicyRule = new BlobInventoryPolicyRule();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("enabled".equals(fieldName)) {
                    deserializedBlobInventoryPolicyRule.enabled = reader.getBoolean();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedBlobInventoryPolicyRule.name = reader.getString();
                    continue;
                }
                if ("destination".equals(fieldName)) {
                    deserializedBlobInventoryPolicyRule.destination = reader.getString();
                    continue;
                }
                if ("definition".equals(fieldName)) {
                    deserializedBlobInventoryPolicyRule.definition = BlobInventoryPolicyDefinition.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedBlobInventoryPolicyRule;
        });
    }
}

