/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.storage.implementation;

import com.azure.resourcemanager.resources.fluentcore.model.implementation.CreatableUpdatableImpl;
import com.azure.resourcemanager.resources.fluentcore.model.implementation.IndexableRefreshableWrapperImpl;
import com.azure.resourcemanager.storage.StorageManager;
import com.azure.resourcemanager.storage.fluent.BlobContainersClient;
import com.azure.resourcemanager.storage.fluent.StorageManagementClient;
import com.azure.resourcemanager.storage.fluent.models.BlobContainerInner;
import com.azure.resourcemanager.storage.implementation.IdParsingUtils;
import com.azure.resourcemanager.storage.models.BlobContainer;
import com.azure.resourcemanager.storage.models.ImmutabilityPolicyProperties;
import com.azure.resourcemanager.storage.models.LeaseDuration;
import com.azure.resourcemanager.storage.models.LeaseState;
import com.azure.resourcemanager.storage.models.LeaseStatus;
import com.azure.resourcemanager.storage.models.LegalHoldProperties;
import com.azure.resourcemanager.storage.models.PublicAccess;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.Map;
import reactor.core.publisher.Mono;

class BlobContainerImpl
extends CreatableUpdatableImpl<BlobContainer, BlobContainerInner, BlobContainerImpl>
implements BlobContainer,
BlobContainer.Definition,
BlobContainer.Update {
    private final StorageManager manager;
    private String resourceGroupName;
    private String accountName;
    private String containerName;
    private PublicAccess cpublicAccess;
    private Map<String, String> cmetadata;
    private PublicAccess upublicAccess;
    private Map<String, String> umetadata;

    BlobContainerImpl(String name, StorageManager manager) {
        super(name, (Object)new BlobContainerInner());
        this.manager = manager;
        this.containerName = name;
    }

    BlobContainerImpl(BlobContainerInner inner, StorageManager manager) {
        super(inner.name(), (Object)inner);
        this.manager = manager;
        this.containerName = inner.name();
        this.resourceGroupName = IdParsingUtils.getValueFromIdByName(inner.id(), "resourceGroups");
        this.accountName = IdParsingUtils.getValueFromIdByName(inner.id(), "storageAccounts");
        this.containerName = IdParsingUtils.getValueFromIdByName(inner.id(), "containers");
    }

    public StorageManager manager() {
        return this.manager;
    }

    public Mono<BlobContainer> createResourceAsync() {
        BlobContainersClient client = ((StorageManagementClient)this.manager().serviceClient()).getBlobContainers();
        return client.createAsync(this.resourceGroupName, this.accountName, this.containerName, ((BlobContainerInner)((Object)this.innerModel())).withPublicAccess(this.cpublicAccess).withMetadata(this.cmetadata)).map(this.innerToFluentMap((IndexableRefreshableWrapperImpl)this));
    }

    public Mono<BlobContainer> updateResourceAsync() {
        BlobContainersClient client = ((StorageManagementClient)this.manager().serviceClient()).getBlobContainers();
        return client.updateAsync(this.resourceGroupName, this.accountName, this.containerName, ((BlobContainerInner)((Object)this.innerModel())).withPublicAccess(this.upublicAccess).withMetadata(this.umetadata)).map(this.innerToFluentMap((IndexableRefreshableWrapperImpl)this));
    }

    protected Mono<BlobContainerInner> getInnerAsync() {
        return ((StorageManagementClient)this.manager().serviceClient()).getBlobContainers().getAsync(this.resourceGroupName, this.accountName, this.containerName);
    }

    public boolean isInCreateMode() {
        return ((BlobContainerInner)((Object)this.innerModel())).id() == null;
    }

    @Override
    public String etag() {
        return ((BlobContainerInner)((Object)this.innerModel())).etag();
    }

    @Override
    public Boolean hasImmutabilityPolicy() {
        return ((BlobContainerInner)((Object)this.innerModel())).hasImmutabilityPolicy();
    }

    @Override
    public Boolean hasLegalHold() {
        return ((BlobContainerInner)((Object)this.innerModel())).hasLegalHold();
    }

    @Override
    public String id() {
        return ((BlobContainerInner)((Object)this.innerModel())).id();
    }

    @Override
    public ImmutabilityPolicyProperties immutabilityPolicy() {
        return ((BlobContainerInner)((Object)this.innerModel())).immutabilityPolicy();
    }

    @Override
    public OffsetDateTime lastModifiedTime() {
        return ((BlobContainerInner)((Object)this.innerModel())).lastModifiedTime();
    }

    @Override
    public LeaseDuration leaseDuration() {
        return ((BlobContainerInner)((Object)this.innerModel())).leaseDuration();
    }

    @Override
    public LeaseState leaseState() {
        return ((BlobContainerInner)((Object)this.innerModel())).leaseState();
    }

    @Override
    public LeaseStatus leaseStatus() {
        return ((BlobContainerInner)((Object)this.innerModel())).leaseStatus();
    }

    @Override
    public LegalHoldProperties legalHold() {
        return ((BlobContainerInner)((Object)this.innerModel())).legalHold();
    }

    @Override
    public Map<String, String> metadata() {
        return ((BlobContainerInner)((Object)this.innerModel())).metadata();
    }

    @Override
    public String name() {
        return ((BlobContainerInner)((Object)this.innerModel())).name();
    }

    @Override
    public PublicAccess publicAccess() {
        return ((BlobContainerInner)((Object)this.innerModel())).publicAccess();
    }

    @Override
    public String type() {
        return ((BlobContainerInner)((Object)this.innerModel())).type();
    }

    @Override
    public BlobContainerImpl withExistingBlobService(String resourceGroupName, String accountName) {
        this.resourceGroupName = resourceGroupName;
        this.accountName = accountName;
        return this;
    }

    @Override
    public BlobContainerImpl withPublicAccess(PublicAccess publicAccess) {
        if (this.isInCreateMode()) {
            this.cpublicAccess = publicAccess;
        } else {
            this.upublicAccess = publicAccess;
        }
        return this;
    }

    @Override
    public BlobContainerImpl withMetadata(Map<String, String> metadata) {
        if (this.isInCreateMode()) {
            this.cmetadata = metadata;
        } else {
            this.umetadata = metadata;
        }
        return this;
    }

    @Override
    public BlobContainerImpl withMetadata(String name, String value) {
        if (this.isInCreateMode()) {
            if (this.cmetadata == null) {
                this.cmetadata = new HashMap<String, String>();
            }
            this.cmetadata.put(name, value);
        } else {
            if (this.umetadata == null) {
                this.umetadata = new HashMap<String, String>();
            }
            this.umetadata.put(name, value);
        }
        return this;
    }
}

