/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.storage.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.storage.models.BlobRestoreRange;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.time.OffsetDateTime;
import java.util.List;

public final class BlobRestoreParameters {
    @JsonIgnore
    private final ClientLogger logger = new ClientLogger(BlobRestoreParameters.class);
    @JsonProperty(value="timeToRestore", required=true)
    private OffsetDateTime timeToRestore;
    @JsonProperty(value="blobRanges", required=true)
    private List<BlobRestoreRange> blobRanges;

    public OffsetDateTime timeToRestore() {
        return this.timeToRestore;
    }

    public BlobRestoreParameters withTimeToRestore(OffsetDateTime timeToRestore) {
        this.timeToRestore = timeToRestore;
        return this;
    }

    public List<BlobRestoreRange> blobRanges() {
        return this.blobRanges;
    }

    public BlobRestoreParameters withBlobRanges(List<BlobRestoreRange> blobRanges) {
        this.blobRanges = blobRanges;
        return this;
    }

    public void validate() {
        if (this.timeToRestore() == null) {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property timeToRestore in model BlobRestoreParameters"));
        }
        if (this.blobRanges() == null) {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property blobRanges in model BlobRestoreParameters"));
        }
        this.blobRanges().forEach(e -> e.validate());
    }
}

