// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.storage.models;

import com.azure.core.util.ExpandableStringEnum;
import java.util.Collection;

/**
 * The status of blob restore progress. Possible values are: - InProgress: Indicates that blob restore is ongoing. -
 * Complete: Indicates that blob restore has been completed successfully. - Failed: Indicates that blob restore is
 * failed.
 */
public final class BlobRestoreProgressStatus extends ExpandableStringEnum<BlobRestoreProgressStatus> {
    /**
     * Static value InProgress for BlobRestoreProgressStatus.
     */
    public static final BlobRestoreProgressStatus IN_PROGRESS = fromString("InProgress");

    /**
     * Static value Complete for BlobRestoreProgressStatus.
     */
    public static final BlobRestoreProgressStatus COMPLETE = fromString("Complete");

    /**
     * Static value Failed for BlobRestoreProgressStatus.
     */
    public static final BlobRestoreProgressStatus FAILED = fromString("Failed");

    /**
     * Creates a new instance of BlobRestoreProgressStatus value.
     * 
     * @deprecated Use the {@link #fromString(String)} factory method.
     */
    @Deprecated
    public BlobRestoreProgressStatus() {
    }

    /**
     * Creates or finds a BlobRestoreProgressStatus from its string representation.
     * 
     * @param name a name to look for.
     * @return the corresponding BlobRestoreProgressStatus.
     */
    public static BlobRestoreProgressStatus fromString(String name) {
        return fromString(name, BlobRestoreProgressStatus.class);
    }

    /**
     * Gets known BlobRestoreProgressStatus values.
     * 
     * @return known BlobRestoreProgressStatus values.
     */
    public static Collection<BlobRestoreProgressStatus> values() {
        return values(BlobRestoreProgressStatus.class);
    }
}
