/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.storage.fluent.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.storage.models.MigrationStatus;
import com.azure.resourcemanager.storage.models.SkuName;
import java.io.IOException;

public final class StorageAccountMigrationProperties
implements JsonSerializable<StorageAccountMigrationProperties> {
    private SkuName targetSkuName;
    private MigrationStatus migrationStatus;
    private String migrationFailedReason;
    private String migrationFailedDetailedReason;
    private static final ClientLogger LOGGER = new ClientLogger(StorageAccountMigrationProperties.class);

    public SkuName targetSkuName() {
        return this.targetSkuName;
    }

    public StorageAccountMigrationProperties withTargetSkuName(SkuName targetSkuName) {
        this.targetSkuName = targetSkuName;
        return this;
    }

    public MigrationStatus migrationStatus() {
        return this.migrationStatus;
    }

    public String migrationFailedReason() {
        return this.migrationFailedReason;
    }

    public String migrationFailedDetailedReason() {
        return this.migrationFailedDetailedReason;
    }

    public void validate() {
        if (this.targetSkuName() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property targetSkuName in model StorageAccountMigrationProperties"));
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("targetSkuName", this.targetSkuName == null ? null : this.targetSkuName.toString());
        return jsonWriter.writeEndObject();
    }

    public static StorageAccountMigrationProperties fromJson(JsonReader jsonReader) throws IOException {
        return (StorageAccountMigrationProperties)jsonReader.readObject(reader -> {
            StorageAccountMigrationProperties deserializedStorageAccountMigrationProperties = new StorageAccountMigrationProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("targetSkuName".equals(fieldName)) {
                    deserializedStorageAccountMigrationProperties.targetSkuName = SkuName.fromString(reader.getString());
                    continue;
                }
                if ("migrationStatus".equals(fieldName)) {
                    deserializedStorageAccountMigrationProperties.migrationStatus = MigrationStatus.fromString(reader.getString());
                    continue;
                }
                if ("migrationFailedReason".equals(fieldName)) {
                    deserializedStorageAccountMigrationProperties.migrationFailedReason = reader.getString();
                    continue;
                }
                if ("migrationFailedDetailedReason".equals(fieldName)) {
                    deserializedStorageAccountMigrationProperties.migrationFailedDetailedReason = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedStorageAccountMigrationProperties;
        });
    }
}

