// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.storage.models;

import com.azure.core.annotation.Immutable;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.storage.fluent.models.BlobInventoryPolicyInner;
import java.io.IOException;
import java.util.List;

/**
 * List of blob inventory policies returned.
 */
@Immutable
public final class ListBlobInventoryPolicy implements JsonSerializable<ListBlobInventoryPolicy> {
    /*
     * List of blob inventory policies.
     */
    private List<BlobInventoryPolicyInner> value;

    /**
     * Creates an instance of ListBlobInventoryPolicy class.
     */
    public ListBlobInventoryPolicy() {
    }

    /**
     * Get the value property: List of blob inventory policies.
     * 
     * @return the value value.
     */
    public List<BlobInventoryPolicyInner> value() {
        return this.value;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (value() != null) {
            value().forEach(e -> e.validate());
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ListBlobInventoryPolicy from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ListBlobInventoryPolicy if the JsonReader was pointing to an instance of it, or null if it
     * was pointing to JSON null.
     * @throws IOException If an error occurs while reading the ListBlobInventoryPolicy.
     */
    public static ListBlobInventoryPolicy fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ListBlobInventoryPolicy deserializedListBlobInventoryPolicy = new ListBlobInventoryPolicy();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("value".equals(fieldName)) {
                    List<BlobInventoryPolicyInner> value
                        = reader.readArray(reader1 -> BlobInventoryPolicyInner.fromJson(reader1));
                    deserializedListBlobInventoryPolicy.value = value;
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedListBlobInventoryPolicy;
        });
    }
}
