// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.storage.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

/**
 * Network Security Perimeter profile.
 */
@Fluent
public final class NetworkSecurityPerimeterConfigurationPropertiesProfile
    implements JsonSerializable<NetworkSecurityPerimeterConfigurationPropertiesProfile> {
    /*
     * Name of the resource
     */
    private String name;

    /*
     * Current access rules version
     */
    private Float accessRulesVersion;

    /*
     * List of Access Rules
     */
    private List<NspAccessRule> accessRules;

    /*
     * Diagnostic settings version
     */
    private Float diagnosticSettingsVersion;

    /*
     * Enabled logging categories
     */
    private List<String> enabledLogCategories;

    /**
     * Creates an instance of NetworkSecurityPerimeterConfigurationPropertiesProfile class.
     */
    public NetworkSecurityPerimeterConfigurationPropertiesProfile() {
    }

    /**
     * Get the name property: Name of the resource.
     * 
     * @return the name value.
     */
    public String name() {
        return this.name;
    }

    /**
     * Set the name property: Name of the resource.
     * 
     * @param name the name value to set.
     * @return the NetworkSecurityPerimeterConfigurationPropertiesProfile object itself.
     */
    public NetworkSecurityPerimeterConfigurationPropertiesProfile withName(String name) {
        this.name = name;
        return this;
    }

    /**
     * Get the accessRulesVersion property: Current access rules version.
     * 
     * @return the accessRulesVersion value.
     */
    public Float accessRulesVersion() {
        return this.accessRulesVersion;
    }

    /**
     * Set the accessRulesVersion property: Current access rules version.
     * 
     * @param accessRulesVersion the accessRulesVersion value to set.
     * @return the NetworkSecurityPerimeterConfigurationPropertiesProfile object itself.
     */
    public NetworkSecurityPerimeterConfigurationPropertiesProfile withAccessRulesVersion(Float accessRulesVersion) {
        this.accessRulesVersion = accessRulesVersion;
        return this;
    }

    /**
     * Get the accessRules property: List of Access Rules.
     * 
     * @return the accessRules value.
     */
    public List<NspAccessRule> accessRules() {
        return this.accessRules;
    }

    /**
     * Set the accessRules property: List of Access Rules.
     * 
     * @param accessRules the accessRules value to set.
     * @return the NetworkSecurityPerimeterConfigurationPropertiesProfile object itself.
     */
    public NetworkSecurityPerimeterConfigurationPropertiesProfile withAccessRules(List<NspAccessRule> accessRules) {
        this.accessRules = accessRules;
        return this;
    }

    /**
     * Get the diagnosticSettingsVersion property: Diagnostic settings version.
     * 
     * @return the diagnosticSettingsVersion value.
     */
    public Float diagnosticSettingsVersion() {
        return this.diagnosticSettingsVersion;
    }

    /**
     * Set the diagnosticSettingsVersion property: Diagnostic settings version.
     * 
     * @param diagnosticSettingsVersion the diagnosticSettingsVersion value to set.
     * @return the NetworkSecurityPerimeterConfigurationPropertiesProfile object itself.
     */
    public NetworkSecurityPerimeterConfigurationPropertiesProfile
        withDiagnosticSettingsVersion(Float diagnosticSettingsVersion) {
        this.diagnosticSettingsVersion = diagnosticSettingsVersion;
        return this;
    }

    /**
     * Get the enabledLogCategories property: Enabled logging categories.
     * 
     * @return the enabledLogCategories value.
     */
    public List<String> enabledLogCategories() {
        return this.enabledLogCategories;
    }

    /**
     * Set the enabledLogCategories property: Enabled logging categories.
     * 
     * @param enabledLogCategories the enabledLogCategories value to set.
     * @return the NetworkSecurityPerimeterConfigurationPropertiesProfile object itself.
     */
    public NetworkSecurityPerimeterConfigurationPropertiesProfile
        withEnabledLogCategories(List<String> enabledLogCategories) {
        this.enabledLogCategories = enabledLogCategories;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (accessRules() != null) {
            accessRules().forEach(e -> e.validate());
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeNumberField("accessRulesVersion", this.accessRulesVersion);
        jsonWriter.writeArrayField("accessRules", this.accessRules, (writer, element) -> writer.writeJson(element));
        jsonWriter.writeNumberField("diagnosticSettingsVersion", this.diagnosticSettingsVersion);
        jsonWriter.writeArrayField("enabledLogCategories", this.enabledLogCategories,
            (writer, element) -> writer.writeString(element));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of NetworkSecurityPerimeterConfigurationPropertiesProfile from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of NetworkSecurityPerimeterConfigurationPropertiesProfile if the JsonReader was pointing to
     * an instance of it, or null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the NetworkSecurityPerimeterConfigurationPropertiesProfile.
     */
    public static NetworkSecurityPerimeterConfigurationPropertiesProfile fromJson(JsonReader jsonReader)
        throws IOException {
        return jsonReader.readObject(reader -> {
            NetworkSecurityPerimeterConfigurationPropertiesProfile deserializedNetworkSecurityPerimeterConfigurationPropertiesProfile
                = new NetworkSecurityPerimeterConfigurationPropertiesProfile();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("name".equals(fieldName)) {
                    deserializedNetworkSecurityPerimeterConfigurationPropertiesProfile.name = reader.getString();
                } else if ("accessRulesVersion".equals(fieldName)) {
                    deserializedNetworkSecurityPerimeterConfigurationPropertiesProfile.accessRulesVersion
                        = reader.getNullable(JsonReader::getFloat);
                } else if ("accessRules".equals(fieldName)) {
                    List<NspAccessRule> accessRules = reader.readArray(reader1 -> NspAccessRule.fromJson(reader1));
                    deserializedNetworkSecurityPerimeterConfigurationPropertiesProfile.accessRules = accessRules;
                } else if ("diagnosticSettingsVersion".equals(fieldName)) {
                    deserializedNetworkSecurityPerimeterConfigurationPropertiesProfile.diagnosticSettingsVersion
                        = reader.getNullable(JsonReader::getFloat);
                } else if ("enabledLogCategories".equals(fieldName)) {
                    List<String> enabledLogCategories = reader.readArray(reader1 -> reader1.getString());
                    deserializedNetworkSecurityPerimeterConfigurationPropertiesProfile.enabledLogCategories
                        = enabledLogCategories;
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedNetworkSecurityPerimeterConfigurationPropertiesProfile;
        });
    }
}
