// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.storage.models;

import com.azure.core.annotation.Immutable;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Maximum provisioned storage, IOPS, bandwidth and number of file shares limits for the storage account.
 */
@Immutable
public final class AccountLimits implements JsonSerializable<AccountLimits> {
    /*
     * The maximum number of file shares limit for the storage account.
     */
    private Integer maxFileShares;

    /*
     * The maximum provisioned storage quota limit in gibibytes for the storage account.
     */
    private Integer maxProvisionedStorageGiB;

    /*
     * The maximum provisioned IOPS limit for the storage account.
     */
    private Integer maxProvisionedIops;

    /*
     * The maximum provisioned bandwidth limit in mebibytes per second for the storage account.
     */
    private Integer maxProvisionedBandwidthMiBPerSec;

    /**
     * Creates an instance of AccountLimits class.
     */
    public AccountLimits() {
    }

    /**
     * Get the maxFileShares property: The maximum number of file shares limit for the storage account.
     * 
     * @return the maxFileShares value.
     */
    public Integer maxFileShares() {
        return this.maxFileShares;
    }

    /**
     * Get the maxProvisionedStorageGiB property: The maximum provisioned storage quota limit in gibibytes for the
     * storage account.
     * 
     * @return the maxProvisionedStorageGiB value.
     */
    public Integer maxProvisionedStorageGiB() {
        return this.maxProvisionedStorageGiB;
    }

    /**
     * Get the maxProvisionedIops property: The maximum provisioned IOPS limit for the storage account.
     * 
     * @return the maxProvisionedIops value.
     */
    public Integer maxProvisionedIops() {
        return this.maxProvisionedIops;
    }

    /**
     * Get the maxProvisionedBandwidthMiBPerSec property: The maximum provisioned bandwidth limit in mebibytes per
     * second for the storage account.
     * 
     * @return the maxProvisionedBandwidthMiBPerSec value.
     */
    public Integer maxProvisionedBandwidthMiBPerSec() {
        return this.maxProvisionedBandwidthMiBPerSec;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of AccountLimits from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of AccountLimits if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IOException If an error occurs while reading the AccountLimits.
     */
    public static AccountLimits fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            AccountLimits deserializedAccountLimits = new AccountLimits();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("maxFileShares".equals(fieldName)) {
                    deserializedAccountLimits.maxFileShares = reader.getNullable(JsonReader::getInt);
                } else if ("maxProvisionedStorageGiB".equals(fieldName)) {
                    deserializedAccountLimits.maxProvisionedStorageGiB = reader.getNullable(JsonReader::getInt);
                } else if ("maxProvisionedIOPS".equals(fieldName)) {
                    deserializedAccountLimits.maxProvisionedIops = reader.getNullable(JsonReader::getInt);
                } else if ("maxProvisionedBandwidthMiBPerSec".equals(fieldName)) {
                    deserializedAccountLimits.maxProvisionedBandwidthMiBPerSec = reader.getNullable(JsonReader::getInt);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedAccountLimits;
        });
    }
}
