/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.storage.fluent.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.storage.fluent.models.ContainerProperties;
import com.azure.resourcemanager.storage.models.AzureEntityResource;
import com.azure.resourcemanager.storage.models.ImmutabilityPolicyProperties;
import com.azure.resourcemanager.storage.models.ImmutableStorageWithVersioning;
import com.azure.resourcemanager.storage.models.LeaseDuration;
import com.azure.resourcemanager.storage.models.LeaseState;
import com.azure.resourcemanager.storage.models.LeaseStatus;
import com.azure.resourcemanager.storage.models.LegalHoldProperties;
import com.azure.resourcemanager.storage.models.PublicAccess;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.util.Map;

public final class BlobContainerInner
extends AzureEntityResource {
    private ContainerProperties innerContainerProperties;
    private String etag;
    private String type;
    private String name;
    private String id;

    private ContainerProperties innerContainerProperties() {
        return this.innerContainerProperties;
    }

    @Override
    public String etag() {
        return this.etag;
    }

    @Override
    public String type() {
        return this.type;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public String id() {
        return this.id;
    }

    public String version() {
        return this.innerContainerProperties() == null ? null : this.innerContainerProperties().version();
    }

    public Boolean deleted() {
        return this.innerContainerProperties() == null ? null : this.innerContainerProperties().deleted();
    }

    public OffsetDateTime deletedTime() {
        return this.innerContainerProperties() == null ? null : this.innerContainerProperties().deletedTime();
    }

    public Integer remainingRetentionDays() {
        return this.innerContainerProperties() == null ? null : this.innerContainerProperties().remainingRetentionDays();
    }

    public String defaultEncryptionScope() {
        return this.innerContainerProperties() == null ? null : this.innerContainerProperties().defaultEncryptionScope();
    }

    public BlobContainerInner withDefaultEncryptionScope(String defaultEncryptionScope) {
        if (this.innerContainerProperties() == null) {
            this.innerContainerProperties = new ContainerProperties();
        }
        this.innerContainerProperties().withDefaultEncryptionScope(defaultEncryptionScope);
        return this;
    }

    public Boolean denyEncryptionScopeOverride() {
        return this.innerContainerProperties() == null ? null : this.innerContainerProperties().denyEncryptionScopeOverride();
    }

    public BlobContainerInner withDenyEncryptionScopeOverride(Boolean denyEncryptionScopeOverride) {
        if (this.innerContainerProperties() == null) {
            this.innerContainerProperties = new ContainerProperties();
        }
        this.innerContainerProperties().withDenyEncryptionScopeOverride(denyEncryptionScopeOverride);
        return this;
    }

    public PublicAccess publicAccess() {
        return this.innerContainerProperties() == null ? null : this.innerContainerProperties().publicAccess();
    }

    public BlobContainerInner withPublicAccess(PublicAccess publicAccess) {
        if (this.innerContainerProperties() == null) {
            this.innerContainerProperties = new ContainerProperties();
        }
        this.innerContainerProperties().withPublicAccess(publicAccess);
        return this;
    }

    public OffsetDateTime lastModifiedTime() {
        return this.innerContainerProperties() == null ? null : this.innerContainerProperties().lastModifiedTime();
    }

    public LeaseStatus leaseStatus() {
        return this.innerContainerProperties() == null ? null : this.innerContainerProperties().leaseStatus();
    }

    public LeaseState leaseState() {
        return this.innerContainerProperties() == null ? null : this.innerContainerProperties().leaseState();
    }

    public LeaseDuration leaseDuration() {
        return this.innerContainerProperties() == null ? null : this.innerContainerProperties().leaseDuration();
    }

    public Map<String, String> metadata() {
        return this.innerContainerProperties() == null ? null : this.innerContainerProperties().metadata();
    }

    public BlobContainerInner withMetadata(Map<String, String> metadata) {
        if (this.innerContainerProperties() == null) {
            this.innerContainerProperties = new ContainerProperties();
        }
        this.innerContainerProperties().withMetadata(metadata);
        return this;
    }

    public ImmutabilityPolicyProperties immutabilityPolicy() {
        return this.innerContainerProperties() == null ? null : this.innerContainerProperties().immutabilityPolicy();
    }

    public LegalHoldProperties legalHold() {
        return this.innerContainerProperties() == null ? null : this.innerContainerProperties().legalHold();
    }

    public Boolean hasLegalHold() {
        return this.innerContainerProperties() == null ? null : this.innerContainerProperties().hasLegalHold();
    }

    public Boolean hasImmutabilityPolicy() {
        return this.innerContainerProperties() == null ? null : this.innerContainerProperties().hasImmutabilityPolicy();
    }

    public ImmutableStorageWithVersioning immutableStorageWithVersioning() {
        return this.innerContainerProperties() == null ? null : this.innerContainerProperties().immutableStorageWithVersioning();
    }

    public BlobContainerInner withImmutableStorageWithVersioning(ImmutableStorageWithVersioning immutableStorageWithVersioning) {
        if (this.innerContainerProperties() == null) {
            this.innerContainerProperties = new ContainerProperties();
        }
        this.innerContainerProperties().withImmutableStorageWithVersioning(immutableStorageWithVersioning);
        return this;
    }

    public Boolean enableNfsV3RootSquash() {
        return this.innerContainerProperties() == null ? null : this.innerContainerProperties().enableNfsV3RootSquash();
    }

    public BlobContainerInner withEnableNfsV3RootSquash(Boolean enableNfsV3RootSquash) {
        if (this.innerContainerProperties() == null) {
            this.innerContainerProperties = new ContainerProperties();
        }
        this.innerContainerProperties().withEnableNfsV3RootSquash(enableNfsV3RootSquash);
        return this;
    }

    public Boolean enableNfsV3AllSquash() {
        return this.innerContainerProperties() == null ? null : this.innerContainerProperties().enableNfsV3AllSquash();
    }

    public BlobContainerInner withEnableNfsV3AllSquash(Boolean enableNfsV3AllSquash) {
        if (this.innerContainerProperties() == null) {
            this.innerContainerProperties = new ContainerProperties();
        }
        this.innerContainerProperties().withEnableNfsV3AllSquash(enableNfsV3AllSquash);
        return this;
    }

    @Override
    public void validate() {
        if (this.innerContainerProperties() != null) {
            this.innerContainerProperties().validate();
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerContainerProperties);
        return jsonWriter.writeEndObject();
    }

    public static BlobContainerInner fromJson(JsonReader jsonReader) throws IOException {
        return (BlobContainerInner)((Object)jsonReader.readObject(reader -> {
            BlobContainerInner deserializedBlobContainerInner = new BlobContainerInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedBlobContainerInner.id = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedBlobContainerInner.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedBlobContainerInner.type = reader.getString();
                    continue;
                }
                if ("etag".equals(fieldName)) {
                    deserializedBlobContainerInner.etag = reader.getString();
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedBlobContainerInner.innerContainerProperties = ContainerProperties.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedBlobContainerInner;
        }));
    }
}

