// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.storage.fluent.models;

import com.azure.core.annotation.Immutable;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * The secrets of Storage Account Local User.
 */
@Immutable
public final class LocalUserRegeneratePasswordResultInner
    implements JsonSerializable<LocalUserRegeneratePasswordResultInner> {
    /*
     * Auto generated password by the server for SSH authentication if hasSshPassword is set to true on the creation of
     * local user.
     */
    private String sshPassword;

    /**
     * Creates an instance of LocalUserRegeneratePasswordResultInner class.
     */
    public LocalUserRegeneratePasswordResultInner() {
    }

    /**
     * Get the sshPassword property: Auto generated password by the server for SSH authentication if hasSshPassword is
     * set to true on the creation of local user.
     * 
     * @return the sshPassword value.
     */
    public String sshPassword() {
        return this.sshPassword;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of LocalUserRegeneratePasswordResultInner from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of LocalUserRegeneratePasswordResultInner if the JsonReader was pointing to an instance of
     * it, or null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the LocalUserRegeneratePasswordResultInner.
     */
    public static LocalUserRegeneratePasswordResultInner fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            LocalUserRegeneratePasswordResultInner deserializedLocalUserRegeneratePasswordResultInner
                = new LocalUserRegeneratePasswordResultInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("sshPassword".equals(fieldName)) {
                    deserializedLocalUserRegeneratePasswordResultInner.sshPassword = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedLocalUserRegeneratePasswordResultInner;
        });
    }
}
