// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.storage.fluent.models;

import com.azure.core.annotation.Immutable;
import com.azure.core.management.ProxyResource;
import com.azure.core.management.SystemData;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.storage.models.NetworkSecurityPerimeter;
import com.azure.resourcemanager.storage.models.NetworkSecurityPerimeterConfigurationPropertiesProfile;
import com.azure.resourcemanager.storage.models.NetworkSecurityPerimeterConfigurationPropertiesResourceAssociation;
import com.azure.resourcemanager.storage.models.NetworkSecurityPerimeterConfigurationProvisioningState;
import com.azure.resourcemanager.storage.models.ProvisioningIssue;
import java.io.IOException;
import java.util.List;

/**
 * The Network Security Perimeter configuration resource.
 */
@Immutable
public final class NetworkSecurityPerimeterConfigurationInner extends ProxyResource {
    /*
     * Properties of the Network Security Perimeter Configuration
     */
    private NetworkSecurityPerimeterConfigurationProperties innerProperties;

    /*
     * Azure Resource Manager metadata containing createdBy and modifiedBy information.
     */
    private SystemData systemData;

    /*
     * The type of the resource.
     */
    private String type;

    /*
     * The name of the resource.
     */
    private String name;

    /*
     * Fully qualified resource Id for the resource.
     */
    private String id;

    /**
     * Creates an instance of NetworkSecurityPerimeterConfigurationInner class.
     */
    public NetworkSecurityPerimeterConfigurationInner() {
    }

    /**
     * Get the innerProperties property: Properties of the Network Security Perimeter Configuration.
     * 
     * @return the innerProperties value.
     */
    private NetworkSecurityPerimeterConfigurationProperties innerProperties() {
        return this.innerProperties;
    }

    /**
     * Get the systemData property: Azure Resource Manager metadata containing createdBy and modifiedBy information.
     * 
     * @return the systemData value.
     */
    public SystemData systemData() {
        return this.systemData;
    }

    /**
     * Get the type property: The type of the resource.
     * 
     * @return the type value.
     */
    @Override
    public String type() {
        return this.type;
    }

    /**
     * Get the name property: The name of the resource.
     * 
     * @return the name value.
     */
    @Override
    public String name() {
        return this.name;
    }

    /**
     * Get the id property: Fully qualified resource Id for the resource.
     * 
     * @return the id value.
     */
    @Override
    public String id() {
        return this.id;
    }

    /**
     * Get the provisioningState property: Provisioning state of Network Security Perimeter configuration propagation.
     * 
     * @return the provisioningState value.
     */
    public NetworkSecurityPerimeterConfigurationProvisioningState provisioningState() {
        return this.innerProperties() == null ? null : this.innerProperties().provisioningState();
    }

    /**
     * Get the provisioningIssues property: List of Provisioning Issues if any.
     * 
     * @return the provisioningIssues value.
     */
    public List<ProvisioningIssue> provisioningIssues() {
        return this.innerProperties() == null ? null : this.innerProperties().provisioningIssues();
    }

    /**
     * Get the networkSecurityPerimeter property: NetworkSecurityPerimeter related information.
     * 
     * @return the networkSecurityPerimeter value.
     */
    public NetworkSecurityPerimeter networkSecurityPerimeter() {
        return this.innerProperties() == null ? null : this.innerProperties().networkSecurityPerimeter();
    }

    /**
     * Get the resourceAssociation property: Information about resource association.
     * 
     * @return the resourceAssociation value.
     */
    public NetworkSecurityPerimeterConfigurationPropertiesResourceAssociation resourceAssociation() {
        return this.innerProperties() == null ? null : this.innerProperties().resourceAssociation();
    }

    /**
     * Get the profile property: Network Security Perimeter profile.
     * 
     * @return the profile value.
     */
    public NetworkSecurityPerimeterConfigurationPropertiesProfile profile() {
        return this.innerProperties() == null ? null : this.innerProperties().profile();
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (innerProperties() != null) {
            innerProperties().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of NetworkSecurityPerimeterConfigurationInner from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of NetworkSecurityPerimeterConfigurationInner if the JsonReader was pointing to an instance
     * of it, or null if it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the NetworkSecurityPerimeterConfigurationInner.
     */
    public static NetworkSecurityPerimeterConfigurationInner fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            NetworkSecurityPerimeterConfigurationInner deserializedNetworkSecurityPerimeterConfigurationInner
                = new NetworkSecurityPerimeterConfigurationInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("id".equals(fieldName)) {
                    deserializedNetworkSecurityPerimeterConfigurationInner.id = reader.getString();
                } else if ("name".equals(fieldName)) {
                    deserializedNetworkSecurityPerimeterConfigurationInner.name = reader.getString();
                } else if ("type".equals(fieldName)) {
                    deserializedNetworkSecurityPerimeterConfigurationInner.type = reader.getString();
                } else if ("properties".equals(fieldName)) {
                    deserializedNetworkSecurityPerimeterConfigurationInner.innerProperties
                        = NetworkSecurityPerimeterConfigurationProperties.fromJson(reader);
                } else if ("systemData".equals(fieldName)) {
                    deserializedNetworkSecurityPerimeterConfigurationInner.systemData = SystemData.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedNetworkSecurityPerimeterConfigurationInner;
        });
    }
}
