// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.storage.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.Map;

/**
 * The QueueProperties model.
 */
@Fluent
public final class QueueProperties implements JsonSerializable<QueueProperties> {
    /*
     * A name-value pair that represents queue metadata.
     */
    private Map<String, String> metadata;

    /*
     * Integer indicating an approximate number of messages in the queue. This number is not lower than the actual
     * number of messages in the queue, but could be higher.
     */
    private Integer approximateMessageCount;

    /**
     * Creates an instance of QueueProperties class.
     */
    public QueueProperties() {
    }

    /**
     * Get the metadata property: A name-value pair that represents queue metadata.
     * 
     * @return the metadata value.
     */
    public Map<String, String> metadata() {
        return this.metadata;
    }

    /**
     * Set the metadata property: A name-value pair that represents queue metadata.
     * 
     * @param metadata the metadata value to set.
     * @return the QueueProperties object itself.
     */
    public QueueProperties withMetadata(Map<String, String> metadata) {
        this.metadata = metadata;
        return this;
    }

    /**
     * Get the approximateMessageCount property: Integer indicating an approximate number of messages in the queue. This
     * number is not lower than the actual number of messages in the queue, but could be higher.
     * 
     * @return the approximateMessageCount value.
     */
    public Integer approximateMessageCount() {
        return this.approximateMessageCount;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeMapField("metadata", this.metadata, (writer, element) -> writer.writeString(element));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of QueueProperties from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of QueueProperties if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IOException If an error occurs while reading the QueueProperties.
     */
    public static QueueProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            QueueProperties deserializedQueueProperties = new QueueProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("metadata".equals(fieldName)) {
                    Map<String, String> metadata = reader.readMap(reader1 -> reader1.getString());
                    deserializedQueueProperties.metadata = metadata;
                } else if ("approximateMessageCount".equals(fieldName)) {
                    deserializedQueueProperties.approximateMessageCount = reader.getNullable(JsonReader::getInt);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedQueueProperties;
        });
    }
}
