// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.storage.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * File Share Paid Bursting properties.
 */
@Fluent
public final class FileSharePropertiesFileSharePaidBursting
    implements JsonSerializable<FileSharePropertiesFileSharePaidBursting> {
    /*
     * Indicates whether paid bursting is enabled for the share. This property is only for file shares created under
     * Files Provisioned v1 SSD account type.
     */
    private Boolean paidBurstingEnabled;

    /*
     * The maximum paid bursting IOPS for the share. This property is only for file shares created under Files
     * Provisioned v1 SSD account type. The maximum allowed value is 102400 which is the maximum allowed IOPS for a
     * share.
     */
    private Integer paidBurstingMaxIops;

    /*
     * The maximum paid bursting bandwidth for the share, in mebibytes per second. This property is only for file shares
     * created under Files Provisioned v1 SSD account type. The maximum allowed value is 10340 which is the maximum
     * allowed bandwidth for a share.
     */
    private Integer paidBurstingMaxBandwidthMibps;

    /**
     * Creates an instance of FileSharePropertiesFileSharePaidBursting class.
     */
    public FileSharePropertiesFileSharePaidBursting() {
    }

    /**
     * Get the paidBurstingEnabled property: Indicates whether paid bursting is enabled for the share. This property is
     * only for file shares created under Files Provisioned v1 SSD account type.
     * 
     * @return the paidBurstingEnabled value.
     */
    public Boolean paidBurstingEnabled() {
        return this.paidBurstingEnabled;
    }

    /**
     * Set the paidBurstingEnabled property: Indicates whether paid bursting is enabled for the share. This property is
     * only for file shares created under Files Provisioned v1 SSD account type.
     * 
     * @param paidBurstingEnabled the paidBurstingEnabled value to set.
     * @return the FileSharePropertiesFileSharePaidBursting object itself.
     */
    public FileSharePropertiesFileSharePaidBursting withPaidBurstingEnabled(Boolean paidBurstingEnabled) {
        this.paidBurstingEnabled = paidBurstingEnabled;
        return this;
    }

    /**
     * Get the paidBurstingMaxIops property: The maximum paid bursting IOPS for the share. This property is only for
     * file shares created under Files Provisioned v1 SSD account type. The maximum allowed value is 102400 which is the
     * maximum allowed IOPS for a share.
     * 
     * @return the paidBurstingMaxIops value.
     */
    public Integer paidBurstingMaxIops() {
        return this.paidBurstingMaxIops;
    }

    /**
     * Set the paidBurstingMaxIops property: The maximum paid bursting IOPS for the share. This property is only for
     * file shares created under Files Provisioned v1 SSD account type. The maximum allowed value is 102400 which is the
     * maximum allowed IOPS for a share.
     * 
     * @param paidBurstingMaxIops the paidBurstingMaxIops value to set.
     * @return the FileSharePropertiesFileSharePaidBursting object itself.
     */
    public FileSharePropertiesFileSharePaidBursting withPaidBurstingMaxIops(Integer paidBurstingMaxIops) {
        this.paidBurstingMaxIops = paidBurstingMaxIops;
        return this;
    }

    /**
     * Get the paidBurstingMaxBandwidthMibps property: The maximum paid bursting bandwidth for the share, in mebibytes
     * per second. This property is only for file shares created under Files Provisioned v1 SSD account type. The
     * maximum allowed value is 10340 which is the maximum allowed bandwidth for a share.
     * 
     * @return the paidBurstingMaxBandwidthMibps value.
     */
    public Integer paidBurstingMaxBandwidthMibps() {
        return this.paidBurstingMaxBandwidthMibps;
    }

    /**
     * Set the paidBurstingMaxBandwidthMibps property: The maximum paid bursting bandwidth for the share, in mebibytes
     * per second. This property is only for file shares created under Files Provisioned v1 SSD account type. The
     * maximum allowed value is 10340 which is the maximum allowed bandwidth for a share.
     * 
     * @param paidBurstingMaxBandwidthMibps the paidBurstingMaxBandwidthMibps value to set.
     * @return the FileSharePropertiesFileSharePaidBursting object itself.
     */
    public FileSharePropertiesFileSharePaidBursting
        withPaidBurstingMaxBandwidthMibps(Integer paidBurstingMaxBandwidthMibps) {
        this.paidBurstingMaxBandwidthMibps = paidBurstingMaxBandwidthMibps;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeBooleanField("paidBurstingEnabled", this.paidBurstingEnabled);
        jsonWriter.writeNumberField("paidBurstingMaxIops", this.paidBurstingMaxIops);
        jsonWriter.writeNumberField("paidBurstingMaxBandwidthMibps", this.paidBurstingMaxBandwidthMibps);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of FileSharePropertiesFileSharePaidBursting from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of FileSharePropertiesFileSharePaidBursting if the JsonReader was pointing to an instance of
     * it, or null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the FileSharePropertiesFileSharePaidBursting.
     */
    public static FileSharePropertiesFileSharePaidBursting fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            FileSharePropertiesFileSharePaidBursting deserializedFileSharePropertiesFileSharePaidBursting
                = new FileSharePropertiesFileSharePaidBursting();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("paidBurstingEnabled".equals(fieldName)) {
                    deserializedFileSharePropertiesFileSharePaidBursting.paidBurstingEnabled
                        = reader.getNullable(JsonReader::getBoolean);
                } else if ("paidBurstingMaxIops".equals(fieldName)) {
                    deserializedFileSharePropertiesFileSharePaidBursting.paidBurstingMaxIops
                        = reader.getNullable(JsonReader::getInt);
                } else if ("paidBurstingMaxBandwidthMibps".equals(fieldName)) {
                    deserializedFileSharePropertiesFileSharePaidBursting.paidBurstingMaxBandwidthMibps
                        = reader.getNullable(JsonReader::getInt);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedFileSharePropertiesFileSharePaidBursting;
        });
    }
}
