// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.storage.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.time.OffsetDateTime;

/**
 * Object level immutability properties of the container.
 */
@Fluent
public final class ImmutableStorageWithVersioning implements JsonSerializable<ImmutableStorageWithVersioning> {
    /*
     * This is an immutable property, when set to true it enables object level immutability at the container level.
     */
    private Boolean enabled;

    /*
     * Returns the date and time the object level immutability was enabled.
     */
    private OffsetDateTime timestamp;

    /*
     * This property denotes the container level immutability to object level immutability migration state.
     */
    private MigrationState migrationState;

    /**
     * Creates an instance of ImmutableStorageWithVersioning class.
     */
    public ImmutableStorageWithVersioning() {
    }

    /**
     * Get the enabled property: This is an immutable property, when set to true it enables object level immutability at
     * the container level.
     * 
     * @return the enabled value.
     */
    public Boolean enabled() {
        return this.enabled;
    }

    /**
     * Set the enabled property: This is an immutable property, when set to true it enables object level immutability at
     * the container level.
     * 
     * @param enabled the enabled value to set.
     * @return the ImmutableStorageWithVersioning object itself.
     */
    public ImmutableStorageWithVersioning withEnabled(Boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    /**
     * Get the timestamp property: Returns the date and time the object level immutability was enabled.
     * 
     * @return the timestamp value.
     */
    public OffsetDateTime timestamp() {
        return this.timestamp;
    }

    /**
     * Get the migrationState property: This property denotes the container level immutability to object level
     * immutability migration state.
     * 
     * @return the migrationState value.
     */
    public MigrationState migrationState() {
        return this.migrationState;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeBooleanField("enabled", this.enabled);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ImmutableStorageWithVersioning from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ImmutableStorageWithVersioning if the JsonReader was pointing to an instance of it, or
     * null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the ImmutableStorageWithVersioning.
     */
    public static ImmutableStorageWithVersioning fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ImmutableStorageWithVersioning deserializedImmutableStorageWithVersioning
                = new ImmutableStorageWithVersioning();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("enabled".equals(fieldName)) {
                    deserializedImmutableStorageWithVersioning.enabled = reader.getNullable(JsonReader::getBoolean);
                } else if ("timeStamp".equals(fieldName)) {
                    deserializedImmutableStorageWithVersioning.timestamp = reader
                        .getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString()));
                } else if ("migrationState".equals(fieldName)) {
                    deserializedImmutableStorageWithVersioning.migrationState
                        = MigrationState.fromString(reader.getString());
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedImmutableStorageWithVersioning;
        });
    }
}
