// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.storage.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

/**
 * The LegalHold property of a blob container.
 */
@Fluent
public final class LegalHoldProperties implements JsonSerializable<LegalHoldProperties> {
    /*
     * The hasLegalHold public property is set to true by SRP if there are at least one existing tag. The hasLegalHold
     * public property is set to false by SRP if all existing legal hold tags are cleared out. There can be a maximum of
     * 1000 blob containers with hasLegalHold=true for a given account.
     */
    private Boolean hasLegalHold;

    /*
     * The list of LegalHold tags of a blob container.
     */
    private List<TagProperty> tags;

    /*
     * Protected append blob writes history.
     */
    private ProtectedAppendWritesHistory protectedAppendWritesHistory;

    /**
     * Creates an instance of LegalHoldProperties class.
     */
    public LegalHoldProperties() {
    }

    /**
     * Get the hasLegalHold property: The hasLegalHold public property is set to true by SRP if there are at least one
     * existing tag. The hasLegalHold public property is set to false by SRP if all existing legal hold tags are cleared
     * out. There can be a maximum of 1000 blob containers with hasLegalHold=true for a given account.
     * 
     * @return the hasLegalHold value.
     */
    public Boolean hasLegalHold() {
        return this.hasLegalHold;
    }

    /**
     * Get the tags property: The list of LegalHold tags of a blob container.
     * 
     * @return the tags value.
     */
    public List<TagProperty> tags() {
        return this.tags;
    }

    /**
     * Set the tags property: The list of LegalHold tags of a blob container.
     * 
     * @param tags the tags value to set.
     * @return the LegalHoldProperties object itself.
     */
    public LegalHoldProperties withTags(List<TagProperty> tags) {
        this.tags = tags;
        return this;
    }

    /**
     * Get the protectedAppendWritesHistory property: Protected append blob writes history.
     * 
     * @return the protectedAppendWritesHistory value.
     */
    public ProtectedAppendWritesHistory protectedAppendWritesHistory() {
        return this.protectedAppendWritesHistory;
    }

    /**
     * Set the protectedAppendWritesHistory property: Protected append blob writes history.
     * 
     * @param protectedAppendWritesHistory the protectedAppendWritesHistory value to set.
     * @return the LegalHoldProperties object itself.
     */
    public LegalHoldProperties
        withProtectedAppendWritesHistory(ProtectedAppendWritesHistory protectedAppendWritesHistory) {
        this.protectedAppendWritesHistory = protectedAppendWritesHistory;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (tags() != null) {
            tags().forEach(e -> e.validate());
        }
        if (protectedAppendWritesHistory() != null) {
            protectedAppendWritesHistory().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("tags", this.tags, (writer, element) -> writer.writeJson(element));
        jsonWriter.writeJsonField("protectedAppendWritesHistory", this.protectedAppendWritesHistory);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of LegalHoldProperties from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of LegalHoldProperties if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IOException If an error occurs while reading the LegalHoldProperties.
     */
    public static LegalHoldProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            LegalHoldProperties deserializedLegalHoldProperties = new LegalHoldProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("hasLegalHold".equals(fieldName)) {
                    deserializedLegalHoldProperties.hasLegalHold = reader.getNullable(JsonReader::getBoolean);
                } else if ("tags".equals(fieldName)) {
                    List<TagProperty> tags = reader.readArray(reader1 -> TagProperty.fromJson(reader1));
                    deserializedLegalHoldProperties.tags = tags;
                } else if ("protectedAppendWritesHistory".equals(fieldName)) {
                    deserializedLegalHoldProperties.protectedAppendWritesHistory
                        = ProtectedAppendWritesHistory.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedLegalHoldProperties;
        });
    }
}
