// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.storage.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Actions are applied to the filtered blobs when the execution condition is met.
 */
@Fluent
public final class ManagementPolicyAction implements JsonSerializable<ManagementPolicyAction> {
    /*
     * The management policy action for base blob
     */
    private ManagementPolicyBaseBlob baseBlob;

    /*
     * The management policy action for snapshot
     */
    private ManagementPolicySnapShot snapshot;

    /*
     * The management policy action for version
     */
    private ManagementPolicyVersion version;

    /**
     * Creates an instance of ManagementPolicyAction class.
     */
    public ManagementPolicyAction() {
    }

    /**
     * Get the baseBlob property: The management policy action for base blob.
     * 
     * @return the baseBlob value.
     */
    public ManagementPolicyBaseBlob baseBlob() {
        return this.baseBlob;
    }

    /**
     * Set the baseBlob property: The management policy action for base blob.
     * 
     * @param baseBlob the baseBlob value to set.
     * @return the ManagementPolicyAction object itself.
     */
    public ManagementPolicyAction withBaseBlob(ManagementPolicyBaseBlob baseBlob) {
        this.baseBlob = baseBlob;
        return this;
    }

    /**
     * Get the snapshot property: The management policy action for snapshot.
     * 
     * @return the snapshot value.
     */
    public ManagementPolicySnapShot snapshot() {
        return this.snapshot;
    }

    /**
     * Set the snapshot property: The management policy action for snapshot.
     * 
     * @param snapshot the snapshot value to set.
     * @return the ManagementPolicyAction object itself.
     */
    public ManagementPolicyAction withSnapshot(ManagementPolicySnapShot snapshot) {
        this.snapshot = snapshot;
        return this;
    }

    /**
     * Get the version property: The management policy action for version.
     * 
     * @return the version value.
     */
    public ManagementPolicyVersion version() {
        return this.version;
    }

    /**
     * Set the version property: The management policy action for version.
     * 
     * @param version the version value to set.
     * @return the ManagementPolicyAction object itself.
     */
    public ManagementPolicyAction withVersion(ManagementPolicyVersion version) {
        this.version = version;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (baseBlob() != null) {
            baseBlob().validate();
        }
        if (snapshot() != null) {
            snapshot().validate();
        }
        if (version() != null) {
            version().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("baseBlob", this.baseBlob);
        jsonWriter.writeJsonField("snapshot", this.snapshot);
        jsonWriter.writeJsonField("version", this.version);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ManagementPolicyAction from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ManagementPolicyAction if the JsonReader was pointing to an instance of it, or null if it
     * was pointing to JSON null.
     * @throws IOException If an error occurs while reading the ManagementPolicyAction.
     */
    public static ManagementPolicyAction fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ManagementPolicyAction deserializedManagementPolicyAction = new ManagementPolicyAction();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("baseBlob".equals(fieldName)) {
                    deserializedManagementPolicyAction.baseBlob = ManagementPolicyBaseBlob.fromJson(reader);
                } else if ("snapshot".equals(fieldName)) {
                    deserializedManagementPolicyAction.snapshot = ManagementPolicySnapShot.fromJson(reader);
                } else if ("version".equals(fieldName)) {
                    deserializedManagementPolicyAction.version = ManagementPolicyVersion.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedManagementPolicyAction;
        });
    }
}
