// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.storage.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Multichannel setting. Applies to Premium FileStorage only.
 */
@Fluent
public final class Multichannel implements JsonSerializable<Multichannel> {
    /*
     * Indicates whether multichannel is enabled
     */
    private Boolean enabled;

    /**
     * Creates an instance of Multichannel class.
     */
    public Multichannel() {
    }

    /**
     * Get the enabled property: Indicates whether multichannel is enabled.
     * 
     * @return the enabled value.
     */
    public Boolean enabled() {
        return this.enabled;
    }

    /**
     * Set the enabled property: Indicates whether multichannel is enabled.
     * 
     * @param enabled the enabled value to set.
     * @return the Multichannel object itself.
     */
    public Multichannel withEnabled(Boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeBooleanField("enabled", this.enabled);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of Multichannel from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of Multichannel if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IOException If an error occurs while reading the Multichannel.
     */
    public static Multichannel fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            Multichannel deserializedMultichannel = new Multichannel();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("enabled".equals(fieldName)) {
                    deserializedMultichannel.enabled = reader.getNullable(JsonReader::getBoolean);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedMultichannel;
        });
    }
}
