// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.storage.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.storage.fluent.models.NetworkSecurityPerimeterConfigurationInner;
import java.io.IOException;
import java.util.List;

/**
 * Result of the List Network Security Perimeter configuration operation.
 */
@Fluent
public final class NetworkSecurityPerimeterConfigurationList
    implements JsonSerializable<NetworkSecurityPerimeterConfigurationList> {
    /*
     * A collection of Network Security Perimeter configurations
     */
    private List<NetworkSecurityPerimeterConfigurationInner> value;

    /*
     * The URI that can be used to request the next set of paged results.
     */
    private String nextLink;

    /**
     * Creates an instance of NetworkSecurityPerimeterConfigurationList class.
     */
    public NetworkSecurityPerimeterConfigurationList() {
    }

    /**
     * Get the value property: A collection of Network Security Perimeter configurations.
     * 
     * @return the value value.
     */
    public List<NetworkSecurityPerimeterConfigurationInner> value() {
        return this.value;
    }

    /**
     * Get the nextLink property: The URI that can be used to request the next set of paged results.
     * 
     * @return the nextLink value.
     */
    public String nextLink() {
        return this.nextLink;
    }

    /**
     * Set the nextLink property: The URI that can be used to request the next set of paged results.
     * 
     * @param nextLink the nextLink value to set.
     * @return the NetworkSecurityPerimeterConfigurationList object itself.
     */
    public NetworkSecurityPerimeterConfigurationList withNextLink(String nextLink) {
        this.nextLink = nextLink;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (value() != null) {
            value().forEach(e -> e.validate());
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("nextLink", this.nextLink);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of NetworkSecurityPerimeterConfigurationList from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of NetworkSecurityPerimeterConfigurationList if the JsonReader was pointing to an instance of
     * it, or null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the NetworkSecurityPerimeterConfigurationList.
     */
    public static NetworkSecurityPerimeterConfigurationList fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            NetworkSecurityPerimeterConfigurationList deserializedNetworkSecurityPerimeterConfigurationList
                = new NetworkSecurityPerimeterConfigurationList();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("value".equals(fieldName)) {
                    List<NetworkSecurityPerimeterConfigurationInner> value
                        = reader.readArray(reader1 -> NetworkSecurityPerimeterConfigurationInner.fromJson(reader1));
                    deserializedNetworkSecurityPerimeterConfigurationList.value = value;
                } else if ("nextLink".equals(fieldName)) {
                    deserializedNetworkSecurityPerimeterConfigurationList.nextLink = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedNetworkSecurityPerimeterConfigurationList;
        });
    }
}
