// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.storage.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * The PermissionScope model.
 */
@Fluent
public final class PermissionScope implements JsonSerializable<PermissionScope> {
    /*
     * The permissions for the local user. Possible values include: Read (r), Write (w), Delete (d), List (l), Create
     * (c), Modify Ownership (o), and Modify Permissions (p).
     */
    private String permissions;

    /*
     * The service used by the local user, e.g. blob, file.
     */
    private String service;

    /*
     * The name of resource, normally the container name or the file share name, used by the local user.
     */
    private String resourceName;

    /**
     * Creates an instance of PermissionScope class.
     */
    public PermissionScope() {
    }

    /**
     * Get the permissions property: The permissions for the local user. Possible values include: Read (r), Write (w),
     * Delete (d), List (l), Create (c), Modify Ownership (o), and Modify Permissions (p).
     * 
     * @return the permissions value.
     */
    public String permissions() {
        return this.permissions;
    }

    /**
     * Set the permissions property: The permissions for the local user. Possible values include: Read (r), Write (w),
     * Delete (d), List (l), Create (c), Modify Ownership (o), and Modify Permissions (p).
     * 
     * @param permissions the permissions value to set.
     * @return the PermissionScope object itself.
     */
    public PermissionScope withPermissions(String permissions) {
        this.permissions = permissions;
        return this;
    }

    /**
     * Get the service property: The service used by the local user, e.g. blob, file.
     * 
     * @return the service value.
     */
    public String service() {
        return this.service;
    }

    /**
     * Set the service property: The service used by the local user, e.g. blob, file.
     * 
     * @param service the service value to set.
     * @return the PermissionScope object itself.
     */
    public PermissionScope withService(String service) {
        this.service = service;
        return this;
    }

    /**
     * Get the resourceName property: The name of resource, normally the container name or the file share name, used by
     * the local user.
     * 
     * @return the resourceName value.
     */
    public String resourceName() {
        return this.resourceName;
    }

    /**
     * Set the resourceName property: The name of resource, normally the container name or the file share name, used by
     * the local user.
     * 
     * @param resourceName the resourceName value to set.
     * @return the PermissionScope object itself.
     */
    public PermissionScope withResourceName(String resourceName) {
        this.resourceName = resourceName;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (permissions() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException("Missing required property permissions in model PermissionScope"));
        }
        if (service() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException("Missing required property service in model PermissionScope"));
        }
        if (resourceName() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException("Missing required property resourceName in model PermissionScope"));
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(PermissionScope.class);

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("permissions", this.permissions);
        jsonWriter.writeStringField("service", this.service);
        jsonWriter.writeStringField("resourceName", this.resourceName);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of PermissionScope from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of PermissionScope if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the PermissionScope.
     */
    public static PermissionScope fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            PermissionScope deserializedPermissionScope = new PermissionScope();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("permissions".equals(fieldName)) {
                    deserializedPermissionScope.permissions = reader.getString();
                } else if ("service".equals(fieldName)) {
                    deserializedPermissionScope.service = reader.getString();
                } else if ("resourceName".equals(fieldName)) {
                    deserializedPermissionScope.resourceName = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedPermissionScope;
        });
    }
}
