// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.storage.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Resource Access Rule.
 */
@Fluent
public final class ResourceAccessRule implements JsonSerializable<ResourceAccessRule> {
    /*
     * Tenant Id
     */
    private String tenantId;

    /*
     * Resource Id
     */
    private String resourceId;

    /**
     * Creates an instance of ResourceAccessRule class.
     */
    public ResourceAccessRule() {
    }

    /**
     * Get the tenantId property: Tenant Id.
     * 
     * @return the tenantId value.
     */
    public String tenantId() {
        return this.tenantId;
    }

    /**
     * Set the tenantId property: Tenant Id.
     * 
     * @param tenantId the tenantId value to set.
     * @return the ResourceAccessRule object itself.
     */
    public ResourceAccessRule withTenantId(String tenantId) {
        this.tenantId = tenantId;
        return this;
    }

    /**
     * Get the resourceId property: Resource Id.
     * 
     * @return the resourceId value.
     */
    public String resourceId() {
        return this.resourceId;
    }

    /**
     * Set the resourceId property: Resource Id.
     * 
     * @param resourceId the resourceId value to set.
     * @return the ResourceAccessRule object itself.
     */
    public ResourceAccessRule withResourceId(String resourceId) {
        this.resourceId = resourceId;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("tenantId", this.tenantId);
        jsonWriter.writeStringField("resourceId", this.resourceId);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ResourceAccessRule from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ResourceAccessRule if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IOException If an error occurs while reading the ResourceAccessRule.
     */
    public static ResourceAccessRule fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ResourceAccessRule deserializedResourceAccessRule = new ResourceAccessRule();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("tenantId".equals(fieldName)) {
                    deserializedResourceAccessRule.tenantId = reader.getString();
                } else if ("resourceId".equals(fieldName)) {
                    deserializedResourceAccessRule.resourceId = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedResourceAccessRule;
        });
    }
}
