// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.storage.models;

import com.azure.core.util.ExpandableStringEnum;
import java.util.Collection;

/**
 * Access Mode of the resource association.
 */
public final class ResourceAssociationAccessMode extends ExpandableStringEnum<ResourceAssociationAccessMode> {
    /**
     * Static value Enforced for ResourceAssociationAccessMode.
     */
    public static final ResourceAssociationAccessMode ENFORCED = fromString("Enforced");

    /**
     * Static value Learning for ResourceAssociationAccessMode.
     */
    public static final ResourceAssociationAccessMode LEARNING = fromString("Learning");

    /**
     * Static value Audit for ResourceAssociationAccessMode.
     */
    public static final ResourceAssociationAccessMode AUDIT = fromString("Audit");

    /**
     * Creates a new instance of ResourceAssociationAccessMode value.
     * 
     * @deprecated Use the {@link #fromString(String)} factory method.
     */
    @Deprecated
    public ResourceAssociationAccessMode() {
    }

    /**
     * Creates or finds a ResourceAssociationAccessMode from its string representation.
     * 
     * @param name a name to look for.
     * @return the corresponding ResourceAssociationAccessMode.
     */
    public static ResourceAssociationAccessMode fromString(String name) {
        return fromString(name, ResourceAssociationAccessMode.class);
    }

    /**
     * Gets known ResourceAssociationAccessMode values.
     * 
     * @return known ResourceAssociationAccessMode values.
     */
    public static Collection<ResourceAssociationAccessMode> values() {
        return values(ResourceAssociationAccessMode.class);
    }
}
