// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.storage.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

/**
 * The restriction because of which SKU cannot be used.
 */
@Fluent
public final class Restriction implements JsonSerializable<Restriction> {
    /*
     * The type of restrictions. As of now only possible value for this is location.
     */
    private String type;

    /*
     * The value of restrictions. If the restriction type is set to location. This would be different locations where
     * the SKU is restricted.
     */
    private List<String> values;

    /*
     * The reason for the restriction. As of now this can be "QuotaId" or "NotAvailableForSubscription". Quota Id is set
     * when the SKU has requiredQuotas parameter as the subscription does not belong to that quota. The
     * "NotAvailableForSubscription" is related to capacity at DC.
     */
    private ReasonCode reasonCode;

    /**
     * Creates an instance of Restriction class.
     */
    public Restriction() {
    }

    /**
     * Get the type property: The type of restrictions. As of now only possible value for this is location.
     * 
     * @return the type value.
     */
    public String type() {
        return this.type;
    }

    /**
     * Get the values property: The value of restrictions. If the restriction type is set to location. This would be
     * different locations where the SKU is restricted.
     * 
     * @return the values value.
     */
    public List<String> values() {
        return this.values;
    }

    /**
     * Get the reasonCode property: The reason for the restriction. As of now this can be "QuotaId" or
     * "NotAvailableForSubscription". Quota Id is set when the SKU has requiredQuotas parameter as the subscription does
     * not belong to that quota. The "NotAvailableForSubscription" is related to capacity at DC.
     * 
     * @return the reasonCode value.
     */
    public ReasonCode reasonCode() {
        return this.reasonCode;
    }

    /**
     * Set the reasonCode property: The reason for the restriction. As of now this can be "QuotaId" or
     * "NotAvailableForSubscription". Quota Id is set when the SKU has requiredQuotas parameter as the subscription does
     * not belong to that quota. The "NotAvailableForSubscription" is related to capacity at DC.
     * 
     * @param reasonCode the reasonCode value to set.
     * @return the Restriction object itself.
     */
    public Restriction withReasonCode(ReasonCode reasonCode) {
        this.reasonCode = reasonCode;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("reasonCode", this.reasonCode == null ? null : this.reasonCode.toString());
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of Restriction from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of Restriction if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IOException If an error occurs while reading the Restriction.
     */
    public static Restriction fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            Restriction deserializedRestriction = new Restriction();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("type".equals(fieldName)) {
                    deserializedRestriction.type = reader.getString();
                } else if ("values".equals(fieldName)) {
                    List<String> values = reader.readArray(reader1 -> reader1.getString());
                    deserializedRestriction.values = values;
                } else if ("reasonCode".equals(fieldName)) {
                    deserializedRestriction.reasonCode = ReasonCode.fromString(reader.getString());
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedRestriction;
        });
    }
}
