// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.storage.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * The SshPublicKey model.
 */
@Fluent
public final class SshPublicKey implements JsonSerializable<SshPublicKey> {
    /*
     * Optional. It is used to store the function/usage of the key
     */
    private String description;

    /*
     * Ssh public key base64 encoded. The format should be: '<keyType> <keyData>', e.g. ssh-rsa AAAABBBB
     */
    private String key;

    /**
     * Creates an instance of SshPublicKey class.
     */
    public SshPublicKey() {
    }

    /**
     * Get the description property: Optional. It is used to store the function/usage of the key.
     * 
     * @return the description value.
     */
    public String description() {
        return this.description;
    }

    /**
     * Set the description property: Optional. It is used to store the function/usage of the key.
     * 
     * @param description the description value to set.
     * @return the SshPublicKey object itself.
     */
    public SshPublicKey withDescription(String description) {
        this.description = description;
        return this;
    }

    /**
     * Get the key property: Ssh public key base64 encoded. The format should be: '&lt;keyType&gt; &lt;keyData&gt;',
     * e.g. ssh-rsa AAAABBBB.
     * 
     * @return the key value.
     */
    public String key() {
        return this.key;
    }

    /**
     * Set the key property: Ssh public key base64 encoded. The format should be: '&lt;keyType&gt; &lt;keyData&gt;',
     * e.g. ssh-rsa AAAABBBB.
     * 
     * @param key the key value to set.
     * @return the SshPublicKey object itself.
     */
    public SshPublicKey withKey(String key) {
        this.key = key;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("description", this.description);
        jsonWriter.writeStringField("key", this.key);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of SshPublicKey from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of SshPublicKey if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IOException If an error occurs while reading the SshPublicKey.
     */
    public static SshPublicKey fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            SshPublicKey deserializedSshPublicKey = new SshPublicKey();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("description".equals(fieldName)) {
                    deserializedSshPublicKey.description = reader.getString();
                } else if ("key".equals(fieldName)) {
                    deserializedSshPublicKey.key = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedSshPublicKey;
        });
    }
}
