// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.storage.models;

import com.azure.core.annotation.Immutable;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * The URIs that are used to perform a retrieval of a public blob, file, web or dfs object via a internet routing
 * endpoint.
 */
@Immutable
public final class StorageAccountInternetEndpoints implements JsonSerializable<StorageAccountInternetEndpoints> {
    /*
     * Gets the blob endpoint.
     */
    private String blob;

    /*
     * Gets the file endpoint.
     */
    private String file;

    /*
     * Gets the web endpoint.
     */
    private String web;

    /*
     * Gets the dfs endpoint.
     */
    private String dfs;

    /**
     * Creates an instance of StorageAccountInternetEndpoints class.
     */
    public StorageAccountInternetEndpoints() {
    }

    /**
     * Get the blob property: Gets the blob endpoint.
     * 
     * @return the blob value.
     */
    public String blob() {
        return this.blob;
    }

    /**
     * Get the file property: Gets the file endpoint.
     * 
     * @return the file value.
     */
    public String file() {
        return this.file;
    }

    /**
     * Get the web property: Gets the web endpoint.
     * 
     * @return the web value.
     */
    public String web() {
        return this.web;
    }

    /**
     * Get the dfs property: Gets the dfs endpoint.
     * 
     * @return the dfs value.
     */
    public String dfs() {
        return this.dfs;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of StorageAccountInternetEndpoints from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of StorageAccountInternetEndpoints if the JsonReader was pointing to an instance of it, or
     * null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the StorageAccountInternetEndpoints.
     */
    public static StorageAccountInternetEndpoints fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            StorageAccountInternetEndpoints deserializedStorageAccountInternetEndpoints
                = new StorageAccountInternetEndpoints();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("blob".equals(fieldName)) {
                    deserializedStorageAccountInternetEndpoints.blob = reader.getString();
                } else if ("file".equals(fieldName)) {
                    deserializedStorageAccountInternetEndpoints.file = reader.getString();
                } else if ("web".equals(fieldName)) {
                    deserializedStorageAccountInternetEndpoints.web = reader.getString();
                } else if ("dfs".equals(fieldName)) {
                    deserializedStorageAccountInternetEndpoints.dfs = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedStorageAccountInternetEndpoints;
        });
    }
}
