// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.storage.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * This defines the sku conversion status object for asynchronous sku conversions.
 */
@Fluent
public final class StorageAccountSkuConversionStatus implements JsonSerializable<StorageAccountSkuConversionStatus> {
    /*
     * This property indicates the current sku conversion status.
     */
    private SkuConversionStatus skuConversionStatus;

    /*
     * This property represents the target sku name to which the account sku is being converted asynchronously.
     */
    private SkuName targetSkuName;

    /*
     * This property represents the sku conversion start time.
     */
    private String startTime;

    /*
     * This property represents the sku conversion end time.
     */
    private String endTime;

    /**
     * Creates an instance of StorageAccountSkuConversionStatus class.
     */
    public StorageAccountSkuConversionStatus() {
    }

    /**
     * Get the skuConversionStatus property: This property indicates the current sku conversion status.
     * 
     * @return the skuConversionStatus value.
     */
    public SkuConversionStatus skuConversionStatus() {
        return this.skuConversionStatus;
    }

    /**
     * Get the targetSkuName property: This property represents the target sku name to which the account sku is being
     * converted asynchronously.
     * 
     * @return the targetSkuName value.
     */
    public SkuName targetSkuName() {
        return this.targetSkuName;
    }

    /**
     * Set the targetSkuName property: This property represents the target sku name to which the account sku is being
     * converted asynchronously.
     * 
     * @param targetSkuName the targetSkuName value to set.
     * @return the StorageAccountSkuConversionStatus object itself.
     */
    public StorageAccountSkuConversionStatus withTargetSkuName(SkuName targetSkuName) {
        this.targetSkuName = targetSkuName;
        return this;
    }

    /**
     * Get the startTime property: This property represents the sku conversion start time.
     * 
     * @return the startTime value.
     */
    public String startTime() {
        return this.startTime;
    }

    /**
     * Get the endTime property: This property represents the sku conversion end time.
     * 
     * @return the endTime value.
     */
    public String endTime() {
        return this.endTime;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("targetSkuName", this.targetSkuName == null ? null : this.targetSkuName.toString());
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of StorageAccountSkuConversionStatus from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of StorageAccountSkuConversionStatus if the JsonReader was pointing to an instance of it, or
     * null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the StorageAccountSkuConversionStatus.
     */
    public static StorageAccountSkuConversionStatus fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            StorageAccountSkuConversionStatus deserializedStorageAccountSkuConversionStatus
                = new StorageAccountSkuConversionStatus();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("skuConversionStatus".equals(fieldName)) {
                    deserializedStorageAccountSkuConversionStatus.skuConversionStatus
                        = SkuConversionStatus.fromString(reader.getString());
                } else if ("targetSkuName".equals(fieldName)) {
                    deserializedStorageAccountSkuConversionStatus.targetSkuName
                        = SkuName.fromString(reader.getString());
                } else if ("startTime".equals(fieldName)) {
                    deserializedStorageAccountSkuConversionStatus.startTime = reader.getString();
                } else if ("endTime".equals(fieldName)) {
                    deserializedStorageAccountSkuConversionStatus.endTime = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedStorageAccountSkuConversionStatus;
        });
    }
}
