// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.storage.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * The storage task assignment report.
 */
@Fluent
public final class StorageTaskAssignmentReport implements JsonSerializable<StorageTaskAssignmentReport> {
    /*
     * The container prefix for the location of storage task assignment report
     */
    private String prefix;

    /**
     * Creates an instance of StorageTaskAssignmentReport class.
     */
    public StorageTaskAssignmentReport() {
    }

    /**
     * Get the prefix property: The container prefix for the location of storage task assignment report.
     * 
     * @return the prefix value.
     */
    public String prefix() {
        return this.prefix;
    }

    /**
     * Set the prefix property: The container prefix for the location of storage task assignment report.
     * 
     * @param prefix the prefix value to set.
     * @return the StorageTaskAssignmentReport object itself.
     */
    public StorageTaskAssignmentReport withPrefix(String prefix) {
        this.prefix = prefix;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (prefix() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property prefix in model StorageTaskAssignmentReport"));
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(StorageTaskAssignmentReport.class);

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("prefix", this.prefix);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of StorageTaskAssignmentReport from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of StorageTaskAssignmentReport if the JsonReader was pointing to an instance of it, or null
     * if it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the StorageTaskAssignmentReport.
     */
    public static StorageTaskAssignmentReport fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            StorageTaskAssignmentReport deserializedStorageTaskAssignmentReport = new StorageTaskAssignmentReport();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("prefix".equals(fieldName)) {
                    deserializedStorageTaskAssignmentReport.prefix = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedStorageTaskAssignmentReport;
        });
    }
}
