/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.storage.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.storage.models.DateAfterModification;
import java.io.IOException;

public final class ManagementPolicyBaseBlob
implements JsonSerializable<ManagementPolicyBaseBlob> {
    private DateAfterModification tierToCool;
    private DateAfterModification tierToArchive;
    private DateAfterModification tierToCold;
    private DateAfterModification tierToHot;
    private DateAfterModification delete;
    private Boolean enableAutoTierToHotFromCool;

    public DateAfterModification tierToCool() {
        return this.tierToCool;
    }

    public ManagementPolicyBaseBlob withTierToCool(DateAfterModification tierToCool) {
        this.tierToCool = tierToCool;
        return this;
    }

    public DateAfterModification tierToArchive() {
        return this.tierToArchive;
    }

    public ManagementPolicyBaseBlob withTierToArchive(DateAfterModification tierToArchive) {
        this.tierToArchive = tierToArchive;
        return this;
    }

    public DateAfterModification tierToCold() {
        return this.tierToCold;
    }

    public ManagementPolicyBaseBlob withTierToCold(DateAfterModification tierToCold) {
        this.tierToCold = tierToCold;
        return this;
    }

    public DateAfterModification tierToHot() {
        return this.tierToHot;
    }

    public ManagementPolicyBaseBlob withTierToHot(DateAfterModification tierToHot) {
        this.tierToHot = tierToHot;
        return this;
    }

    public DateAfterModification delete() {
        return this.delete;
    }

    public ManagementPolicyBaseBlob withDelete(DateAfterModification delete) {
        this.delete = delete;
        return this;
    }

    public Boolean enableAutoTierToHotFromCool() {
        return this.enableAutoTierToHotFromCool;
    }

    public ManagementPolicyBaseBlob withEnableAutoTierToHotFromCool(Boolean enableAutoTierToHotFromCool) {
        this.enableAutoTierToHotFromCool = enableAutoTierToHotFromCool;
        return this;
    }

    public void validate() {
        if (this.tierToCool() != null) {
            this.tierToCool().validate();
        }
        if (this.tierToArchive() != null) {
            this.tierToArchive().validate();
        }
        if (this.tierToCold() != null) {
            this.tierToCold().validate();
        }
        if (this.tierToHot() != null) {
            this.tierToHot().validate();
        }
        if (this.delete() != null) {
            this.delete().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("tierToCool", (JsonSerializable)this.tierToCool);
        jsonWriter.writeJsonField("tierToArchive", (JsonSerializable)this.tierToArchive);
        jsonWriter.writeJsonField("tierToCold", (JsonSerializable)this.tierToCold);
        jsonWriter.writeJsonField("tierToHot", (JsonSerializable)this.tierToHot);
        jsonWriter.writeJsonField("delete", (JsonSerializable)this.delete);
        jsonWriter.writeBooleanField("enableAutoTierToHotFromCool", this.enableAutoTierToHotFromCool);
        return jsonWriter.writeEndObject();
    }

    public static ManagementPolicyBaseBlob fromJson(JsonReader jsonReader) throws IOException {
        return (ManagementPolicyBaseBlob)jsonReader.readObject(reader -> {
            ManagementPolicyBaseBlob deserializedManagementPolicyBaseBlob = new ManagementPolicyBaseBlob();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("tierToCool".equals(fieldName)) {
                    deserializedManagementPolicyBaseBlob.tierToCool = DateAfterModification.fromJson(reader);
                    continue;
                }
                if ("tierToArchive".equals(fieldName)) {
                    deserializedManagementPolicyBaseBlob.tierToArchive = DateAfterModification.fromJson(reader);
                    continue;
                }
                if ("tierToCold".equals(fieldName)) {
                    deserializedManagementPolicyBaseBlob.tierToCold = DateAfterModification.fromJson(reader);
                    continue;
                }
                if ("tierToHot".equals(fieldName)) {
                    deserializedManagementPolicyBaseBlob.tierToHot = DateAfterModification.fromJson(reader);
                    continue;
                }
                if ("delete".equals(fieldName)) {
                    deserializedManagementPolicyBaseBlob.delete = DateAfterModification.fromJson(reader);
                    continue;
                }
                if ("enableAutoTierToHotFromCool".equals(fieldName)) {
                    deserializedManagementPolicyBaseBlob.enableAutoTierToHotFromCool = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedManagementPolicyBaseBlob;
        });
    }
}

