// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.storage.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.storage.models.Kind;
import com.azure.resourcemanager.storage.models.Restriction;
import com.azure.resourcemanager.storage.models.SkuCapability;
import com.azure.resourcemanager.storage.models.SkuInformationLocationInfoItem;
import com.azure.resourcemanager.storage.models.SkuName;
import com.azure.resourcemanager.storage.models.SkuTier;
import java.io.IOException;
import java.util.List;

/**
 * Storage SKU and its properties.
 */
@Fluent
public final class SkuInformationInner implements JsonSerializable<SkuInformationInner> {
    /*
     * The SKU name. Required for account creation; optional for update. Note that in older versions, SKU name was
     * called accountType.
     */
    private SkuName name;

    /*
     * The SKU tier. This is based on the SKU name.
     */
    private SkuTier tier;

    /*
     * The type of the resource, usually it is 'storageAccounts'.
     */
    private String resourceType;

    /*
     * Indicates the type of storage account.
     */
    private Kind kind;

    /*
     * The set of locations that the SKU is available. This will be supported and registered Azure Geo Regions (e.g.
     * West US, East US, Southeast Asia, etc.).
     */
    private List<String> locations;

    /*
     * The locationInfo property.
     */
    private List<SkuInformationLocationInfoItem> locationInfo;

    /*
     * The capability information in the specified SKU, including file encryption, network ACLs, change notification,
     * etc.
     */
    private List<SkuCapability> capabilities;

    /*
     * The restrictions because of which SKU cannot be used. This is empty if there are no restrictions.
     */
    private List<Restriction> restrictions;

    /**
     * Creates an instance of SkuInformationInner class.
     */
    public SkuInformationInner() {
    }

    /**
     * Get the name property: The SKU name. Required for account creation; optional for update. Note that in older
     * versions, SKU name was called accountType.
     * 
     * @return the name value.
     */
    public SkuName name() {
        return this.name;
    }

    /**
     * Set the name property: The SKU name. Required for account creation; optional for update. Note that in older
     * versions, SKU name was called accountType.
     * 
     * @param name the name value to set.
     * @return the SkuInformationInner object itself.
     */
    public SkuInformationInner withName(SkuName name) {
        this.name = name;
        return this;
    }

    /**
     * Get the tier property: The SKU tier. This is based on the SKU name.
     * 
     * @return the tier value.
     */
    public SkuTier tier() {
        return this.tier;
    }

    /**
     * Get the resourceType property: The type of the resource, usually it is 'storageAccounts'.
     * 
     * @return the resourceType value.
     */
    public String resourceType() {
        return this.resourceType;
    }

    /**
     * Get the kind property: Indicates the type of storage account.
     * 
     * @return the kind value.
     */
    public Kind kind() {
        return this.kind;
    }

    /**
     * Get the locations property: The set of locations that the SKU is available. This will be supported and registered
     * Azure Geo Regions (e.g. West US, East US, Southeast Asia, etc.).
     * 
     * @return the locations value.
     */
    public List<String> locations() {
        return this.locations;
    }

    /**
     * Get the locationInfo property: The locationInfo property.
     * 
     * @return the locationInfo value.
     */
    public List<SkuInformationLocationInfoItem> locationInfo() {
        return this.locationInfo;
    }

    /**
     * Set the locationInfo property: The locationInfo property.
     * 
     * @param locationInfo the locationInfo value to set.
     * @return the SkuInformationInner object itself.
     */
    public SkuInformationInner withLocationInfo(List<SkuInformationLocationInfoItem> locationInfo) {
        this.locationInfo = locationInfo;
        return this;
    }

    /**
     * Get the capabilities property: The capability information in the specified SKU, including file encryption,
     * network ACLs, change notification, etc.
     * 
     * @return the capabilities value.
     */
    public List<SkuCapability> capabilities() {
        return this.capabilities;
    }

    /**
     * Get the restrictions property: The restrictions because of which SKU cannot be used. This is empty if there are
     * no restrictions.
     * 
     * @return the restrictions value.
     */
    public List<Restriction> restrictions() {
        return this.restrictions;
    }

    /**
     * Set the restrictions property: The restrictions because of which SKU cannot be used. This is empty if there are
     * no restrictions.
     * 
     * @param restrictions the restrictions value to set.
     * @return the SkuInformationInner object itself.
     */
    public SkuInformationInner withRestrictions(List<Restriction> restrictions) {
        this.restrictions = restrictions;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (name() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException("Missing required property name in model SkuInformationInner"));
        }
        if (locationInfo() != null) {
            locationInfo().forEach(e -> e.validate());
        }
        if (capabilities() != null) {
            capabilities().forEach(e -> e.validate());
        }
        if (restrictions() != null) {
            restrictions().forEach(e -> e.validate());
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(SkuInformationInner.class);

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.name == null ? null : this.name.toString());
        jsonWriter.writeArrayField("locationInfo", this.locationInfo, (writer, element) -> writer.writeJson(element));
        jsonWriter.writeArrayField("restrictions", this.restrictions, (writer, element) -> writer.writeJson(element));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of SkuInformationInner from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of SkuInformationInner if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the SkuInformationInner.
     */
    public static SkuInformationInner fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            SkuInformationInner deserializedSkuInformationInner = new SkuInformationInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("name".equals(fieldName)) {
                    deserializedSkuInformationInner.name = SkuName.fromString(reader.getString());
                } else if ("tier".equals(fieldName)) {
                    deserializedSkuInformationInner.tier = SkuTier.fromString(reader.getString());
                } else if ("resourceType".equals(fieldName)) {
                    deserializedSkuInformationInner.resourceType = reader.getString();
                } else if ("kind".equals(fieldName)) {
                    deserializedSkuInformationInner.kind = Kind.fromString(reader.getString());
                } else if ("locations".equals(fieldName)) {
                    List<String> locations = reader.readArray(reader1 -> reader1.getString());
                    deserializedSkuInformationInner.locations = locations;
                } else if ("locationInfo".equals(fieldName)) {
                    List<SkuInformationLocationInfoItem> locationInfo
                        = reader.readArray(reader1 -> SkuInformationLocationInfoItem.fromJson(reader1));
                    deserializedSkuInformationInner.locationInfo = locationInfo;
                } else if ("capabilities".equals(fieldName)) {
                    List<SkuCapability> capabilities = reader.readArray(reader1 -> SkuCapability.fromJson(reader1));
                    deserializedSkuInformationInner.capabilities = capabilities;
                } else if ("restrictions".equals(fieldName)) {
                    List<Restriction> restrictions = reader.readArray(reader1 -> Restriction.fromJson(reader1));
                    deserializedSkuInformationInner.restrictions = restrictions;
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedSkuInformationInner;
        });
    }
}
