// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.storage.models;

import com.azure.core.annotation.Immutable;
import com.azure.core.management.ProxyResource;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Entity Resource
 * 
 * The resource model definition for an Azure Resource Manager resource with an etag.
 */
@Immutable
public class AzureEntityResource extends ProxyResource {
    /*
     * Resource Etag.
     */
    private String etag;

    /*
     * The type of the resource.
     */
    private String type;

    /*
     * The name of the resource.
     */
    private String name;

    /*
     * Fully qualified resource Id for the resource.
     */
    private String id;

    /**
     * Creates an instance of AzureEntityResource class.
     */
    public AzureEntityResource() {
    }

    /**
     * Get the etag property: Resource Etag.
     * 
     * @return the etag value.
     */
    public String etag() {
        return this.etag;
    }

    /**
     * Set the etag property: Resource Etag.
     * 
     * @param etag the etag value to set.
     * @return the AzureEntityResource object itself.
     */
    AzureEntityResource withEtag(String etag) {
        this.etag = etag;
        return this;
    }

    /**
     * Get the type property: The type of the resource.
     * 
     * @return the type value.
     */
    @Override
    public String type() {
        return this.type;
    }

    /**
     * Get the name property: The name of the resource.
     * 
     * @return the name value.
     */
    @Override
    public String name() {
        return this.name;
    }

    /**
     * Get the id property: Fully qualified resource Id for the resource.
     * 
     * @return the id value.
     */
    @Override
    public String id() {
        return this.id;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of AzureEntityResource from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of AzureEntityResource if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the AzureEntityResource.
     */
    public static AzureEntityResource fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            AzureEntityResource deserializedAzureEntityResource = new AzureEntityResource();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("id".equals(fieldName)) {
                    deserializedAzureEntityResource.id = reader.getString();
                } else if ("name".equals(fieldName)) {
                    deserializedAzureEntityResource.name = reader.getString();
                } else if ("type".equals(fieldName)) {
                    deserializedAzureEntityResource.type = reader.getString();
                } else if ("etag".equals(fieldName)) {
                    deserializedAzureEntityResource.etag = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedAzureEntityResource;
        });
    }
}
