// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.storage.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * The complex type of the zonal placement details.
 */
@Fluent
public final class Placement implements JsonSerializable<Placement> {
    /*
     * The availability zone pinning policy for the storage account.
     */
    private ZonePlacementPolicy zonePlacementPolicy;

    /**
     * Creates an instance of Placement class.
     */
    public Placement() {
    }

    /**
     * Get the zonePlacementPolicy property: The availability zone pinning policy for the storage account.
     * 
     * @return the zonePlacementPolicy value.
     */
    public ZonePlacementPolicy zonePlacementPolicy() {
        return this.zonePlacementPolicy;
    }

    /**
     * Set the zonePlacementPolicy property: The availability zone pinning policy for the storage account.
     * 
     * @param zonePlacementPolicy the zonePlacementPolicy value to set.
     * @return the Placement object itself.
     */
    public Placement withZonePlacementPolicy(ZonePlacementPolicy zonePlacementPolicy) {
        this.zonePlacementPolicy = zonePlacementPolicy;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("zonePlacementPolicy",
            this.zonePlacementPolicy == null ? null : this.zonePlacementPolicy.toString());
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of Placement from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of Placement if the JsonReader was pointing to an instance of it, or null if it was pointing
     * to JSON null.
     * @throws IOException If an error occurs while reading the Placement.
     */
    public static Placement fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            Placement deserializedPlacement = new Placement();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("zonePlacementPolicy".equals(fieldName)) {
                    deserializedPlacement.zonePlacementPolicy = ZonePlacementPolicy.fromString(reader.getString());
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedPlacement;
        });
    }
}
