// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.storage.models;

import com.azure.core.annotation.Immutable;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

/**
 * The SkuInformationLocationInfoItem model.
 */
@Immutable
public final class SkuInformationLocationInfoItem implements JsonSerializable<SkuInformationLocationInfoItem> {
    /*
     * Describes the location for the product where storage account resource can be created.
     */
    private String location;

    /*
     * Describes the available zones for the product where storage account resource can be created.
     */
    private List<String> zones;

    /**
     * Creates an instance of SkuInformationLocationInfoItem class.
     */
    public SkuInformationLocationInfoItem() {
    }

    /**
     * Get the location property: Describes the location for the product where storage account resource can be created.
     * 
     * @return the location value.
     */
    public String location() {
        return this.location;
    }

    /**
     * Get the zones property: Describes the available zones for the product where storage account resource can be
     * created.
     * 
     * @return the zones value.
     */
    public List<String> zones() {
        return this.zones;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of SkuInformationLocationInfoItem from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of SkuInformationLocationInfoItem if the JsonReader was pointing to an instance of it, or
     * null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the SkuInformationLocationInfoItem.
     */
    public static SkuInformationLocationInfoItem fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            SkuInformationLocationInfoItem deserializedSkuInformationLocationInfoItem
                = new SkuInformationLocationInfoItem();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("location".equals(fieldName)) {
                    deserializedSkuInformationLocationInfoItem.location = reader.getString();
                } else if ("zones".equals(fieldName)) {
                    List<String> zones = reader.readArray(reader1 -> reader1.getString());
                    deserializedSkuInformationLocationInfoItem.zones = zones;
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedSkuInformationLocationInfoItem;
        });
    }
}
