/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.storage.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.storage.models.CorsRuleAllowedMethodsItem;
import java.io.IOException;
import java.util.List;

public final class CorsRule
implements JsonSerializable<CorsRule> {
    private List<String> allowedOrigins;
    private List<CorsRuleAllowedMethodsItem> allowedMethods;
    private int maxAgeInSeconds;
    private List<String> exposedHeaders;
    private List<String> allowedHeaders;
    private static final ClientLogger LOGGER = new ClientLogger(CorsRule.class);

    public List<String> allowedOrigins() {
        return this.allowedOrigins;
    }

    public CorsRule withAllowedOrigins(List<String> allowedOrigins) {
        this.allowedOrigins = allowedOrigins;
        return this;
    }

    public List<CorsRuleAllowedMethodsItem> allowedMethods() {
        return this.allowedMethods;
    }

    public CorsRule withAllowedMethods(List<CorsRuleAllowedMethodsItem> allowedMethods) {
        this.allowedMethods = allowedMethods;
        return this;
    }

    public int maxAgeInSeconds() {
        return this.maxAgeInSeconds;
    }

    public CorsRule withMaxAgeInSeconds(int maxAgeInSeconds) {
        this.maxAgeInSeconds = maxAgeInSeconds;
        return this;
    }

    public List<String> exposedHeaders() {
        return this.exposedHeaders;
    }

    public CorsRule withExposedHeaders(List<String> exposedHeaders) {
        this.exposedHeaders = exposedHeaders;
        return this;
    }

    public List<String> allowedHeaders() {
        return this.allowedHeaders;
    }

    public CorsRule withAllowedHeaders(List<String> allowedHeaders) {
        this.allowedHeaders = allowedHeaders;
        return this;
    }

    public void validate() {
        if (this.allowedOrigins() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property allowedOrigins in model CorsRule"));
        }
        if (this.allowedMethods() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property allowedMethods in model CorsRule"));
        }
        if (this.exposedHeaders() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property exposedHeaders in model CorsRule"));
        }
        if (this.allowedHeaders() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property allowedHeaders in model CorsRule"));
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("allowedOrigins", this.allowedOrigins, (writer, element) -> writer.writeString(element));
        jsonWriter.writeArrayField("allowedMethods", this.allowedMethods, (writer, element) -> writer.writeString(element == null ? null : element.toString()));
        jsonWriter.writeIntField("maxAgeInSeconds", this.maxAgeInSeconds);
        jsonWriter.writeArrayField("exposedHeaders", this.exposedHeaders, (writer, element) -> writer.writeString(element));
        jsonWriter.writeArrayField("allowedHeaders", this.allowedHeaders, (writer, element) -> writer.writeString(element));
        return jsonWriter.writeEndObject();
    }

    public static CorsRule fromJson(JsonReader jsonReader) throws IOException {
        return (CorsRule)jsonReader.readObject(reader -> {
            CorsRule deserializedCorsRule = new CorsRule();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("allowedOrigins".equals(fieldName)) {
                    List allowedOrigins;
                    deserializedCorsRule.allowedOrigins = allowedOrigins = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("allowedMethods".equals(fieldName)) {
                    List allowedMethods;
                    deserializedCorsRule.allowedMethods = allowedMethods = reader.readArray(reader1 -> CorsRuleAllowedMethodsItem.fromString(reader1.getString()));
                    continue;
                }
                if ("maxAgeInSeconds".equals(fieldName)) {
                    deserializedCorsRule.maxAgeInSeconds = reader.getInt();
                    continue;
                }
                if ("exposedHeaders".equals(fieldName)) {
                    List exposedHeaders;
                    deserializedCorsRule.exposedHeaders = exposedHeaders = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("allowedHeaders".equals(fieldName)) {
                    List allowedHeaders;
                    deserializedCorsRule.allowedHeaders = allowedHeaders = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedCorsRule;
        });
    }
}

