/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.storage.implementation;

import com.azure.resourcemanager.resources.fluentcore.model.implementation.CreatableUpdatableImpl;
import com.azure.resourcemanager.resources.fluentcore.model.implementation.IndexableRefreshableWrapperImpl;
import com.azure.resourcemanager.resources.fluentcore.utils.ETagState;
import com.azure.resourcemanager.storage.StorageManager;
import com.azure.resourcemanager.storage.fluent.BlobContainersClient;
import com.azure.resourcemanager.storage.fluent.StorageManagementClient;
import com.azure.resourcemanager.storage.fluent.models.ImmutabilityPolicyInner;
import com.azure.resourcemanager.storage.implementation.IdParsingUtils;
import com.azure.resourcemanager.storage.models.ImmutabilityPolicy;
import com.azure.resourcemanager.storage.models.ImmutabilityPolicyState;
import reactor.core.publisher.Mono;

class ImmutabilityPolicyImpl
extends CreatableUpdatableImpl<ImmutabilityPolicy, ImmutabilityPolicyInner, ImmutabilityPolicyImpl>
implements ImmutabilityPolicy,
ImmutabilityPolicy.Definition,
ImmutabilityPolicy.Update {
    private final StorageManager manager;
    private String resourceGroupName;
    private String accountName;
    private String containerName;
    private int cImmutabilityPeriodSinceCreationInDays;
    private int uImmutabilityPeriodSinceCreationInDays;
    private final ETagState eTagState = new ETagState();

    ImmutabilityPolicyImpl(String name, StorageManager manager) {
        super(name, (Object)new ImmutabilityPolicyInner());
        this.manager = manager;
        this.containerName = name;
    }

    ImmutabilityPolicyImpl(ImmutabilityPolicyInner inner, StorageManager manager) {
        super(inner.name(), (Object)inner);
        this.manager = manager;
        this.containerName = inner.name();
        this.resourceGroupName = IdParsingUtils.getValueFromIdByName(inner.id(), "resourceGroups");
        this.accountName = IdParsingUtils.getValueFromIdByName(inner.id(), "storageAccounts");
        this.containerName = IdParsingUtils.getValueFromIdByName(inner.id(), "containers");
    }

    public StorageManager manager() {
        return this.manager;
    }

    public Mono<ImmutabilityPolicy> createResourceAsync() {
        BlobContainersClient client = ((StorageManagementClient)this.manager().serviceClient()).getBlobContainers();
        return client.createOrUpdateImmutabilityPolicyAsync(this.resourceGroupName, this.accountName, this.containerName, null, this.cImmutabilityPeriodSinceCreationInDays, null).map(this.innerToFluentMap((IndexableRefreshableWrapperImpl)this));
    }

    public Mono<ImmutabilityPolicy> updateResourceAsync() {
        BlobContainersClient client = ((StorageManagementClient)this.manager().serviceClient()).getBlobContainers();
        return client.createOrUpdateImmutabilityPolicyAsync(this.resourceGroupName, this.accountName, this.containerName, this.eTagState.ifMatchValueOnUpdate(((ImmutabilityPolicyInner)((Object)this.innerModel())).etag()), this.uImmutabilityPeriodSinceCreationInDays, null).map(this.innerToFluentMap((IndexableRefreshableWrapperImpl)this)).map(self -> {
            this.eTagState.clear();
            return self;
        });
    }

    protected Mono<ImmutabilityPolicyInner> getInnerAsync() {
        BlobContainersClient client = ((StorageManagementClient)this.manager().serviceClient()).getBlobContainers();
        return client.getImmutabilityPolicyAsync(this.resourceGroupName, this.accountName, this.containerName, null);
    }

    public boolean isInCreateMode() {
        return ((ImmutabilityPolicyInner)((Object)this.innerModel())).id() == null;
    }

    @Override
    public String etag() {
        return ((ImmutabilityPolicyInner)((Object)this.innerModel())).etag();
    }

    @Override
    public String id() {
        return ((ImmutabilityPolicyInner)((Object)this.innerModel())).id();
    }

    @Override
    public int immutabilityPeriodSinceCreationInDays() {
        return ((ImmutabilityPolicyInner)((Object)this.innerModel())).immutabilityPeriodSinceCreationInDays();
    }

    @Override
    public String name() {
        return ((ImmutabilityPolicyInner)((Object)this.innerModel())).name();
    }

    @Override
    public ImmutabilityPolicyState state() {
        return ((ImmutabilityPolicyInner)((Object)this.innerModel())).state();
    }

    @Override
    public String type() {
        return ((ImmutabilityPolicyInner)((Object)this.innerModel())).type();
    }

    @Override
    public ImmutabilityPolicyImpl withExistingContainer(String resourceGroupName, String accountName, String containerName) {
        this.resourceGroupName = resourceGroupName;
        this.accountName = accountName;
        this.containerName = containerName;
        return this;
    }

    @Override
    public ImmutabilityPolicyImpl withETagCheck() {
        this.eTagState.withImplicitETagCheckOnCreateOrUpdate(this.isInCreateMode());
        return this;
    }

    @Override
    public ImmutabilityPolicyImpl withETagCheck(String eTagValue) {
        this.eTagState.withExplicitETagCheckOnUpdate(eTagValue);
        return this;
    }

    @Override
    public ImmutabilityPolicyImpl withImmutabilityPeriodSinceCreationInDays(int immutabilityPeriodSinceCreationInDays) {
        if (this.isInCreateMode()) {
            this.cImmutabilityPeriodSinceCreationInDays = immutabilityPeriodSinceCreationInDays;
        } else {
            this.uImmutabilityPeriodSinceCreationInDays = immutabilityPeriodSinceCreationInDays;
        }
        return this;
    }
}

