/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.storage.implementation;

import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.resources.fluentcore.model.implementation.CreatableUpdatableImpl;
import com.azure.resourcemanager.resources.fluentcore.model.implementation.IndexableRefreshableWrapperImpl;
import com.azure.resourcemanager.storage.StorageManager;
import com.azure.resourcemanager.storage.fluent.ManagementPoliciesClient;
import com.azure.resourcemanager.storage.fluent.StorageManagementClient;
import com.azure.resourcemanager.storage.fluent.models.ManagementPolicyInner;
import com.azure.resourcemanager.storage.implementation.IdParsingUtils;
import com.azure.resourcemanager.storage.implementation.PolicyRuleImpl;
import com.azure.resourcemanager.storage.models.BlobTypes;
import com.azure.resourcemanager.storage.models.ManagementPolicy;
import com.azure.resourcemanager.storage.models.ManagementPolicyBaseBlob;
import com.azure.resourcemanager.storage.models.ManagementPolicyName;
import com.azure.resourcemanager.storage.models.ManagementPolicyRule;
import com.azure.resourcemanager.storage.models.ManagementPolicySchema;
import com.azure.resourcemanager.storage.models.ManagementPolicySnapShot;
import com.azure.resourcemanager.storage.models.PolicyRule;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import reactor.core.publisher.Mono;

class ManagementPolicyImpl
extends CreatableUpdatableImpl<ManagementPolicy, ManagementPolicyInner, ManagementPolicyImpl>
implements ManagementPolicy,
ManagementPolicy.Definition,
ManagementPolicy.Update {
    private final ClientLogger logger = new ClientLogger(this.getClass());
    private final StorageManager manager;
    private String resourceGroupName;
    private String accountName;
    private ManagementPolicySchema cpolicy;
    private ManagementPolicySchema upolicy;

    ManagementPolicyImpl(String name, StorageManager manager) {
        super(name, (Object)new ManagementPolicyInner());
        this.manager = manager;
        this.accountName = name;
        this.cpolicy = new ManagementPolicySchema();
        this.upolicy = new ManagementPolicySchema();
    }

    ManagementPolicyImpl(ManagementPolicyInner inner, StorageManager manager) {
        super(inner.name(), (Object)inner);
        this.manager = manager;
        this.accountName = inner.name();
        this.resourceGroupName = IdParsingUtils.getValueFromIdByName(inner.id(), "resourceGroups");
        this.accountName = IdParsingUtils.getValueFromIdByName(inner.id(), "storageAccounts");
        this.cpolicy = new ManagementPolicySchema();
        this.upolicy = new ManagementPolicySchema();
    }

    public StorageManager manager() {
        return this.manager;
    }

    public Mono<ManagementPolicy> createResourceAsync() {
        ManagementPoliciesClient client = ((StorageManagementClient)this.manager().serviceClient()).getManagementPolicies();
        return client.createOrUpdateAsync(this.resourceGroupName, this.accountName, ManagementPolicyName.DEFAULT, this.cpolicy).map(resource -> {
            this.resetCreateUpdateParameters();
            return resource;
        }).map(this.innerToFluentMap((IndexableRefreshableWrapperImpl)this));
    }

    public Mono<ManagementPolicy> updateResourceAsync() {
        ManagementPoliciesClient client = ((StorageManagementClient)this.manager().serviceClient()).getManagementPolicies();
        return client.createOrUpdateAsync(this.resourceGroupName, this.accountName, ManagementPolicyName.DEFAULT, this.upolicy).map(resource -> {
            this.resetCreateUpdateParameters();
            return resource;
        }).map(this.innerToFluentMap((IndexableRefreshableWrapperImpl)this));
    }

    protected Mono<ManagementPolicyInner> getInnerAsync() {
        ManagementPoliciesClient client = ((StorageManagementClient)this.manager().serviceClient()).getManagementPolicies();
        return client.getAsync(this.resourceGroupName, this.accountName, ManagementPolicyName.DEFAULT);
    }

    public boolean isInCreateMode() {
        return ((ManagementPolicyInner)((Object)this.innerModel())).id() == null;
    }

    private void resetCreateUpdateParameters() {
        this.cpolicy = new ManagementPolicySchema();
        this.upolicy = new ManagementPolicySchema();
    }

    @Override
    public String id() {
        return ((ManagementPolicyInner)((Object)this.innerModel())).id();
    }

    @Override
    public OffsetDateTime lastModifiedTime() {
        return ((ManagementPolicyInner)((Object)this.innerModel())).lastModifiedTime();
    }

    @Override
    public String name() {
        return ((ManagementPolicyInner)((Object)this.innerModel())).name();
    }

    @Override
    public ManagementPolicySchema policy() {
        return ((ManagementPolicyInner)((Object)this.innerModel())).policy();
    }

    @Override
    public String type() {
        return ((ManagementPolicyInner)((Object)this.innerModel())).type();
    }

    @Override
    public List<PolicyRule> rules() {
        List<ManagementPolicyRule> originalRules = this.policy().rules();
        ArrayList<PolicyRule.DefinitionStages.PrefixActionFork> returnRules = new ArrayList<PolicyRule.DefinitionStages.PrefixActionFork>();
        for (ManagementPolicyRule originalRule : originalRules) {
            ManagementPolicySnapShot originalSnapshotActions;
            ManagementPolicyBaseBlob originalBaseBlobActions;
            List<String> originalBlobTypes = originalRule.definition().filters().blobTypes();
            ArrayList<BlobTypes> returnBlobTypes = new ArrayList<BlobTypes>();
            for (String originalBlobType : originalBlobTypes) {
                returnBlobTypes.add(BlobTypes.fromString(originalBlobType));
            }
            PolicyRule.DefinitionStages.PrefixActionFork returnRule = new PolicyRuleImpl(originalRule.name()).withLifecycleRuleType().withBlobTypesToFilterFor(returnBlobTypes);
            if (originalRule.definition().filters().prefixMatch() != null) {
                ((PolicyRuleImpl)returnRule).withPrefixesToFilterFor((List)originalRule.definition().filters().prefixMatch());
            }
            if ((originalBaseBlobActions = originalRule.definition().actions().baseBlob()) != null) {
                if (originalBaseBlobActions.tierToCool() != null) {
                    ((PolicyRuleImpl)returnRule).withTierToCoolActionOnBaseBlob(originalBaseBlobActions.tierToCool().daysAfterModificationGreaterThan().floatValue());
                }
                if (originalBaseBlobActions.tierToArchive() != null) {
                    ((PolicyRuleImpl)returnRule).withTierToArchiveActionOnBaseBlob(originalBaseBlobActions.tierToArchive().daysAfterModificationGreaterThan().floatValue());
                }
                if (originalBaseBlobActions.delete() != null) {
                    ((PolicyRuleImpl)returnRule).withDeleteActionOnBaseBlob(originalBaseBlobActions.delete().daysAfterModificationGreaterThan().floatValue());
                }
            }
            if ((originalSnapshotActions = originalRule.definition().actions().snapshot()) != null && originalSnapshotActions.delete() != null) {
                ((PolicyRuleImpl)returnRule).withDeleteActionOnSnapShot(originalSnapshotActions.delete().daysAfterCreationGreaterThan());
            }
            returnRules.add(returnRule);
        }
        return Collections.unmodifiableList(returnRules);
    }

    @Override
    public ManagementPolicyImpl withExistingStorageAccount(String resourceGroupName, String accountName) {
        this.resourceGroupName = resourceGroupName;
        this.accountName = accountName;
        return this;
    }

    @Override
    public ManagementPolicyImpl withPolicy(ManagementPolicySchema policy) {
        if (this.isInCreateMode()) {
            this.cpolicy = policy;
        } else {
            this.upolicy = policy;
        }
        return this;
    }

    @Override
    public PolicyRule.DefinitionStages.Blank defineRule(String name) {
        return new PolicyRuleImpl(this, name);
    }

    void defineRule(PolicyRuleImpl policyRuleImpl) {
        if (this.isInCreateMode()) {
            if (this.cpolicy.rules() == null) {
                this.cpolicy.withRules(new ArrayList<ManagementPolicyRule>());
            }
            List<ManagementPolicyRule> rules = this.cpolicy.rules();
            rules.add(policyRuleImpl.innerModel());
            this.cpolicy.withRules(rules);
        } else {
            if (this.upolicy.rules() == null) {
                this.upolicy.withRules(new ArrayList<ManagementPolicyRule>());
            }
            List<ManagementPolicyRule> rules = this.upolicy.rules();
            rules.add(policyRuleImpl.innerModel());
            this.upolicy.withRules(rules);
        }
    }

    @Override
    public PolicyRule.Update updateRule(String name) {
        ManagementPolicyRule ruleToUpdate = null;
        for (ManagementPolicyRule rule : this.policy().rules()) {
            if (!rule.name().equals(name)) continue;
            ruleToUpdate = rule;
        }
        if (ruleToUpdate == null) {
            throw this.logger.logExceptionAsError((RuntimeException)new UnsupportedOperationException("There is no rule that exists with the name " + name + ". Please define a rule with this name before updating."));
        }
        return new PolicyRuleImpl(ruleToUpdate, this);
    }

    @Override
    public ManagementPolicy.Update withoutRule(String name) {
        ManagementPolicyRule ruleToDelete = null;
        for (ManagementPolicyRule rule : this.policy().rules()) {
            if (!rule.name().equals(name)) continue;
            ruleToDelete = rule;
        }
        if (ruleToDelete == null) {
            throw this.logger.logExceptionAsError((RuntimeException)new UnsupportedOperationException("There is no rule that exists with the name " + name + " so this rule can not be deleted."));
        }
        List<ManagementPolicyRule> currentRules = this.upolicy.rules();
        currentRules.remove(ruleToDelete);
        this.upolicy.withRules(currentRules);
        return this;
    }
}

