/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.storage.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.storage.models.BlobInventoryPolicyRule;
import com.azure.resourcemanager.storage.models.InventoryRuleType;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

public final class BlobInventoryPolicySchema {
    @JsonIgnore
    private final ClientLogger logger = new ClientLogger(BlobInventoryPolicySchema.class);
    @JsonProperty(value="enabled", required=true)
    private boolean enabled;
    @JsonProperty(value="destination", required=true)
    private String destination;
    @JsonProperty(value="type", required=true)
    private InventoryRuleType type;
    @JsonProperty(value="rules", required=true)
    private List<BlobInventoryPolicyRule> rules;

    public boolean enabled() {
        return this.enabled;
    }

    public BlobInventoryPolicySchema withEnabled(boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    public String destination() {
        return this.destination;
    }

    public BlobInventoryPolicySchema withDestination(String destination) {
        this.destination = destination;
        return this;
    }

    public InventoryRuleType type() {
        return this.type;
    }

    public BlobInventoryPolicySchema withType(InventoryRuleType type) {
        this.type = type;
        return this;
    }

    public List<BlobInventoryPolicyRule> rules() {
        return this.rules;
    }

    public BlobInventoryPolicySchema withRules(List<BlobInventoryPolicyRule> rules) {
        this.rules = rules;
        return this;
    }

    public void validate() {
        if (this.destination() == null) {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property destination in model BlobInventoryPolicySchema"));
        }
        if (this.type() == null) {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property type in model BlobInventoryPolicySchema"));
        }
        if (this.rules() == null) {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property rules in model BlobInventoryPolicySchema"));
        }
        this.rules().forEach(e -> e.validate());
    }
}

