/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.storage.models;

import com.azure.core.annotation.JsonFlatten;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.storage.models.AccessTier;
import com.azure.resourcemanager.storage.models.AzureFilesIdentityBasedAuthentication;
import com.azure.resourcemanager.storage.models.CustomDomain;
import com.azure.resourcemanager.storage.models.Encryption;
import com.azure.resourcemanager.storage.models.Identity;
import com.azure.resourcemanager.storage.models.KeyPolicy;
import com.azure.resourcemanager.storage.models.Kind;
import com.azure.resourcemanager.storage.models.LargeFileSharesState;
import com.azure.resourcemanager.storage.models.MinimumTlsVersion;
import com.azure.resourcemanager.storage.models.NetworkRuleSet;
import com.azure.resourcemanager.storage.models.RoutingPreference;
import com.azure.resourcemanager.storage.models.SasPolicy;
import com.azure.resourcemanager.storage.models.Sku;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Map;

@JsonFlatten
public class StorageAccountUpdateParameters {
    @JsonIgnore
    private final ClientLogger logger = new ClientLogger(StorageAccountUpdateParameters.class);
    @JsonProperty(value="sku")
    private Sku sku;
    @JsonProperty(value="tags")
    private Map<String, String> tags;
    @JsonProperty(value="identity")
    private Identity identity;
    @JsonProperty(value="kind")
    private Kind kind;
    @JsonProperty(value="properties.customDomain")
    private CustomDomain customDomain;
    @JsonProperty(value="properties.encryption")
    private Encryption encryption;
    @JsonProperty(value="properties.sasPolicy")
    private SasPolicy sasPolicy;
    @JsonProperty(value="properties.keyPolicy")
    private KeyPolicy keyPolicy;
    @JsonProperty(value="properties.accessTier")
    private AccessTier accessTier;
    @JsonProperty(value="properties.azureFilesIdentityBasedAuthentication")
    private AzureFilesIdentityBasedAuthentication azureFilesIdentityBasedAuthentication;
    @JsonProperty(value="properties.supportsHttpsTrafficOnly")
    private Boolean enableHttpsTrafficOnly;
    @JsonProperty(value="properties.networkAcls")
    private NetworkRuleSet networkRuleSet;
    @JsonProperty(value="properties.largeFileSharesState")
    private LargeFileSharesState largeFileSharesState;
    @JsonProperty(value="properties.routingPreference")
    private RoutingPreference routingPreference;
    @JsonProperty(value="properties.allowBlobPublicAccess")
    private Boolean allowBlobPublicAccess;
    @JsonProperty(value="properties.minimumTlsVersion")
    private MinimumTlsVersion minimumTlsVersion;
    @JsonProperty(value="properties.allowSharedKeyAccess")
    private Boolean allowSharedKeyAccess;

    public Sku sku() {
        return this.sku;
    }

    public StorageAccountUpdateParameters withSku(Sku sku) {
        this.sku = sku;
        return this;
    }

    public Map<String, String> tags() {
        return this.tags;
    }

    public StorageAccountUpdateParameters withTags(Map<String, String> tags) {
        this.tags = tags;
        return this;
    }

    public Identity identity() {
        return this.identity;
    }

    public StorageAccountUpdateParameters withIdentity(Identity identity) {
        this.identity = identity;
        return this;
    }

    public Kind kind() {
        return this.kind;
    }

    public StorageAccountUpdateParameters withKind(Kind kind) {
        this.kind = kind;
        return this;
    }

    public CustomDomain customDomain() {
        return this.customDomain;
    }

    public StorageAccountUpdateParameters withCustomDomain(CustomDomain customDomain) {
        this.customDomain = customDomain;
        return this;
    }

    public Encryption encryption() {
        return this.encryption;
    }

    public StorageAccountUpdateParameters withEncryption(Encryption encryption) {
        this.encryption = encryption;
        return this;
    }

    public SasPolicy sasPolicy() {
        return this.sasPolicy;
    }

    public StorageAccountUpdateParameters withSasPolicy(SasPolicy sasPolicy) {
        this.sasPolicy = sasPolicy;
        return this;
    }

    public KeyPolicy keyPolicy() {
        return this.keyPolicy;
    }

    public StorageAccountUpdateParameters withKeyPolicy(KeyPolicy keyPolicy) {
        this.keyPolicy = keyPolicy;
        return this;
    }

    public AccessTier accessTier() {
        return this.accessTier;
    }

    public StorageAccountUpdateParameters withAccessTier(AccessTier accessTier) {
        this.accessTier = accessTier;
        return this;
    }

    public AzureFilesIdentityBasedAuthentication azureFilesIdentityBasedAuthentication() {
        return this.azureFilesIdentityBasedAuthentication;
    }

    public StorageAccountUpdateParameters withAzureFilesIdentityBasedAuthentication(AzureFilesIdentityBasedAuthentication azureFilesIdentityBasedAuthentication) {
        this.azureFilesIdentityBasedAuthentication = azureFilesIdentityBasedAuthentication;
        return this;
    }

    public Boolean enableHttpsTrafficOnly() {
        return this.enableHttpsTrafficOnly;
    }

    public StorageAccountUpdateParameters withEnableHttpsTrafficOnly(Boolean enableHttpsTrafficOnly) {
        this.enableHttpsTrafficOnly = enableHttpsTrafficOnly;
        return this;
    }

    public NetworkRuleSet networkRuleSet() {
        return this.networkRuleSet;
    }

    public StorageAccountUpdateParameters withNetworkRuleSet(NetworkRuleSet networkRuleSet) {
        this.networkRuleSet = networkRuleSet;
        return this;
    }

    public LargeFileSharesState largeFileSharesState() {
        return this.largeFileSharesState;
    }

    public StorageAccountUpdateParameters withLargeFileSharesState(LargeFileSharesState largeFileSharesState) {
        this.largeFileSharesState = largeFileSharesState;
        return this;
    }

    public RoutingPreference routingPreference() {
        return this.routingPreference;
    }

    public StorageAccountUpdateParameters withRoutingPreference(RoutingPreference routingPreference) {
        this.routingPreference = routingPreference;
        return this;
    }

    public Boolean allowBlobPublicAccess() {
        return this.allowBlobPublicAccess;
    }

    public StorageAccountUpdateParameters withAllowBlobPublicAccess(Boolean allowBlobPublicAccess) {
        this.allowBlobPublicAccess = allowBlobPublicAccess;
        return this;
    }

    public MinimumTlsVersion minimumTlsVersion() {
        return this.minimumTlsVersion;
    }

    public StorageAccountUpdateParameters withMinimumTlsVersion(MinimumTlsVersion minimumTlsVersion) {
        this.minimumTlsVersion = minimumTlsVersion;
        return this;
    }

    public Boolean allowSharedKeyAccess() {
        return this.allowSharedKeyAccess;
    }

    public StorageAccountUpdateParameters withAllowSharedKeyAccess(Boolean allowSharedKeyAccess) {
        this.allowSharedKeyAccess = allowSharedKeyAccess;
        return this;
    }

    public void validate() {
        if (this.sku() != null) {
            this.sku().validate();
        }
        if (this.identity() != null) {
            this.identity().validate();
        }
        if (this.customDomain() != null) {
            this.customDomain().validate();
        }
        if (this.encryption() != null) {
            this.encryption().validate();
        }
        if (this.sasPolicy() != null) {
            this.sasPolicy().validate();
        }
        if (this.keyPolicy() != null) {
            this.keyPolicy().validate();
        }
        if (this.azureFilesIdentityBasedAuthentication() != null) {
            this.azureFilesIdentityBasedAuthentication().validate();
        }
        if (this.networkRuleSet() != null) {
            this.networkRuleSet().validate();
        }
        if (this.routingPreference() != null) {
            this.routingPreference().validate();
        }
    }
}

