/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.storage.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.storage.models.EncryptionService;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;

public final class EncryptionServices {
    @JsonIgnore
    private final ClientLogger logger = new ClientLogger(EncryptionServices.class);
    @JsonProperty(value="blob")
    private EncryptionService blob;
    @JsonProperty(value="file")
    private EncryptionService file;
    @JsonProperty(value="table")
    private EncryptionService table;
    @JsonProperty(value="queue")
    private EncryptionService queue;

    public EncryptionService blob() {
        return this.blob;
    }

    public EncryptionServices withBlob(EncryptionService blob) {
        this.blob = blob;
        return this;
    }

    public EncryptionService file() {
        return this.file;
    }

    public EncryptionServices withFile(EncryptionService file) {
        this.file = file;
        return this;
    }

    public EncryptionService table() {
        return this.table;
    }

    public EncryptionServices withTable(EncryptionService table) {
        this.table = table;
        return this;
    }

    public EncryptionService queue() {
        return this.queue;
    }

    public EncryptionServices withQueue(EncryptionService queue) {
        this.queue = queue;
        return this;
    }

    public void validate() {
        if (this.blob() != null) {
            this.blob().validate();
        }
        if (this.file() != null) {
            this.file().validate();
        }
        if (this.table() != null) {
            this.table().validate();
        }
        if (this.queue() != null) {
            this.queue().validate();
        }
    }
}

