// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.storage.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.management.ProxyResource;
import com.azure.core.util.logging.ClientLogger;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;

/** Properties of the table, including Id, resource name, resource type. */
@Fluent
public final class TableInner extends ProxyResource {
    @JsonIgnore private final ClientLogger logger = new ClientLogger(TableInner.class);

    /*
     * Table resource properties.
     */
    @JsonProperty(value = "properties")
    private TableProperties innerTableProperties;

    /**
     * Get the innerTableProperties property: Table resource properties.
     *
     * @return the innerTableProperties value.
     */
    private TableProperties innerTableProperties() {
        return this.innerTableProperties;
    }

    /**
     * Get the tableName property: Table name under the specified account.
     *
     * @return the tableName value.
     */
    public String tableName() {
        return this.innerTableProperties() == null ? null : this.innerTableProperties().tableName();
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (innerTableProperties() != null) {
            innerTableProperties().validate();
        }
    }
}
