// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.storage.models;

import com.azure.core.util.ExpandableStringEnum;
import com.fasterxml.jackson.annotation.JsonCreator;
import java.util.Collection;

/** Defines values for EncryptionScopeState. */
public final class EncryptionScopeState extends ExpandableStringEnum<EncryptionScopeState> {
    /** Static value Enabled for EncryptionScopeState. */
    public static final EncryptionScopeState ENABLED = fromString("Enabled");

    /** Static value Disabled for EncryptionScopeState. */
    public static final EncryptionScopeState DISABLED = fromString("Disabled");

    /**
     * Creates or finds a EncryptionScopeState from its string representation.
     *
     * @param name a name to look for.
     * @return the corresponding EncryptionScopeState.
     */
    @JsonCreator
    public static EncryptionScopeState fromString(String name) {
        return fromString(name, EncryptionScopeState.class);
    }

    /** @return known EncryptionScopeState values. */
    public static Collection<EncryptionScopeState> values() {
        return values(EncryptionScopeState.class);
    }
}
