// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.subscription.implementation;

import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.subscription.fluent.AliasClient;
import com.azure.resourcemanager.subscription.fluent.models.PutAliasListResultInner;
import com.azure.resourcemanager.subscription.fluent.models.PutAliasResponseInner;
import com.azure.resourcemanager.subscription.models.Alias;
import com.azure.resourcemanager.subscription.models.PutAliasListResult;
import com.azure.resourcemanager.subscription.models.PutAliasRequest;
import com.azure.resourcemanager.subscription.models.PutAliasResponse;

public final class AliasImpl implements Alias {
    private static final ClientLogger LOGGER = new ClientLogger(AliasImpl.class);

    private final AliasClient innerClient;

    private final com.azure.resourcemanager.subscription.SubscriptionManager serviceManager;

    public AliasImpl(
        AliasClient innerClient, com.azure.resourcemanager.subscription.SubscriptionManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    public PutAliasResponse create(String aliasName, PutAliasRequest body) {
        PutAliasResponseInner inner = this.serviceClient().create(aliasName, body);
        if (inner != null) {
            return new PutAliasResponseImpl(inner, this.manager());
        } else {
            return null;
        }
    }

    public PutAliasResponse create(String aliasName, PutAliasRequest body, Context context) {
        PutAliasResponseInner inner = this.serviceClient().create(aliasName, body, context);
        if (inner != null) {
            return new PutAliasResponseImpl(inner, this.manager());
        } else {
            return null;
        }
    }

    public Response<PutAliasResponse> getWithResponse(String aliasName, Context context) {
        Response<PutAliasResponseInner> inner = this.serviceClient().getWithResponse(aliasName, context);
        if (inner != null) {
            return new SimpleResponse<>(
                inner.getRequest(),
                inner.getStatusCode(),
                inner.getHeaders(),
                new PutAliasResponseImpl(inner.getValue(), this.manager()));
        } else {
            return null;
        }
    }

    public PutAliasResponse get(String aliasName) {
        PutAliasResponseInner inner = this.serviceClient().get(aliasName);
        if (inner != null) {
            return new PutAliasResponseImpl(inner, this.manager());
        } else {
            return null;
        }
    }

    public Response<Void> deleteWithResponse(String aliasName, Context context) {
        return this.serviceClient().deleteWithResponse(aliasName, context);
    }

    public void delete(String aliasName) {
        this.serviceClient().delete(aliasName);
    }

    public Response<PutAliasListResult> listWithResponse(Context context) {
        Response<PutAliasListResultInner> inner = this.serviceClient().listWithResponse(context);
        if (inner != null) {
            return new SimpleResponse<>(
                inner.getRequest(),
                inner.getStatusCode(),
                inner.getHeaders(),
                new PutAliasListResultImpl(inner.getValue(), this.manager()));
        } else {
            return null;
        }
    }

    public PutAliasListResult list() {
        PutAliasListResultInner inner = this.serviceClient().list();
        if (inner != null) {
            return new PutAliasListResultImpl(inner, this.manager());
        } else {
            return null;
        }
    }

    private AliasClient serviceClient() {
        return this.innerClient;
    }

    private com.azure.resourcemanager.subscription.SubscriptionManager manager() {
        return this.serviceManager;
    }
}
