// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.subscription.implementation;

import com.azure.resourcemanager.subscription.fluent.models.SubscriptionInner;
import com.azure.resourcemanager.subscription.models.Subscription;
import com.azure.resourcemanager.subscription.models.SubscriptionPolicies;
import com.azure.resourcemanager.subscription.models.SubscriptionState;
import java.util.Collections;
import java.util.Map;

public final class SubscriptionImpl implements Subscription {
    private SubscriptionInner innerObject;

    private final com.azure.resourcemanager.subscription.SubscriptionManager serviceManager;

    SubscriptionImpl(
        SubscriptionInner innerObject, com.azure.resourcemanager.subscription.SubscriptionManager serviceManager) {
        this.innerObject = innerObject;
        this.serviceManager = serviceManager;
    }

    public String id() {
        return this.innerModel().id();
    }

    public String subscriptionId() {
        return this.innerModel().subscriptionId();
    }

    public String displayName() {
        return this.innerModel().displayName();
    }

    public SubscriptionState state() {
        return this.innerModel().state();
    }

    public String tenantId() {
        return this.innerModel().tenantId();
    }

    public Map<String, String> tags() {
        Map<String, String> inner = this.innerModel().tags();
        if (inner != null) {
            return Collections.unmodifiableMap(inner);
        } else {
            return Collections.emptyMap();
        }
    }

    public SubscriptionPolicies subscriptionPolicies() {
        return this.innerModel().subscriptionPolicies();
    }

    public String authorizationSource() {
        return this.innerModel().authorizationSource();
    }

    public SubscriptionInner innerModel() {
        return this.innerObject;
    }

    private com.azure.resourcemanager.subscription.SubscriptionManager manager() {
        return this.serviceManager;
    }
}
