// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.subscription.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.subscription.fluent.SubscriptionsClient;
import com.azure.resourcemanager.subscription.fluent.models.LocationInner;
import com.azure.resourcemanager.subscription.fluent.models.SubscriptionInner;
import com.azure.resourcemanager.subscription.models.Location;
import com.azure.resourcemanager.subscription.models.Subscription;
import com.azure.resourcemanager.subscription.models.Subscriptions;

public final class SubscriptionsImpl implements Subscriptions {
    private static final ClientLogger LOGGER = new ClientLogger(SubscriptionsImpl.class);

    private final SubscriptionsClient innerClient;

    private final com.azure.resourcemanager.subscription.SubscriptionManager serviceManager;

    public SubscriptionsImpl(
        SubscriptionsClient innerClient, com.azure.resourcemanager.subscription.SubscriptionManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    public PagedIterable<Location> listLocations(String subscriptionId) {
        PagedIterable<LocationInner> inner = this.serviceClient().listLocations(subscriptionId);
        return Utils.mapPage(inner, inner1 -> new LocationImpl(inner1, this.manager()));
    }

    public PagedIterable<Location> listLocations(String subscriptionId, Context context) {
        PagedIterable<LocationInner> inner = this.serviceClient().listLocations(subscriptionId, context);
        return Utils.mapPage(inner, inner1 -> new LocationImpl(inner1, this.manager()));
    }

    public Response<Subscription> getWithResponse(String subscriptionId, Context context) {
        Response<SubscriptionInner> inner = this.serviceClient().getWithResponse(subscriptionId, context);
        if (inner != null) {
            return new SimpleResponse<>(
                inner.getRequest(),
                inner.getStatusCode(),
                inner.getHeaders(),
                new SubscriptionImpl(inner.getValue(), this.manager()));
        } else {
            return null;
        }
    }

    public Subscription get(String subscriptionId) {
        SubscriptionInner inner = this.serviceClient().get(subscriptionId);
        if (inner != null) {
            return new SubscriptionImpl(inner, this.manager());
        } else {
            return null;
        }
    }

    public PagedIterable<Subscription> list() {
        PagedIterable<SubscriptionInner> inner = this.serviceClient().list();
        return Utils.mapPage(inner, inner1 -> new SubscriptionImpl(inner1, this.manager()));
    }

    public PagedIterable<Subscription> list(Context context) {
        PagedIterable<SubscriptionInner> inner = this.serviceClient().list(context);
        return Utils.mapPage(inner, inner1 -> new SubscriptionImpl(inner1, this.manager()));
    }

    private SubscriptionsClient serviceClient() {
        return this.innerClient;
    }

    private com.azure.resourcemanager.subscription.SubscriptionManager manager() {
        return this.serviceManager;
    }
}
