// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.subscription.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.subscription.fluent.TenantsClient;
import com.azure.resourcemanager.subscription.fluent.models.TenantIdDescriptionInner;
import com.azure.resourcemanager.subscription.models.TenantIdDescription;
import com.azure.resourcemanager.subscription.models.Tenants;

public final class TenantsImpl implements Tenants {
    private static final ClientLogger LOGGER = new ClientLogger(TenantsImpl.class);

    private final TenantsClient innerClient;

    private final com.azure.resourcemanager.subscription.SubscriptionManager serviceManager;

    public TenantsImpl(
        TenantsClient innerClient, com.azure.resourcemanager.subscription.SubscriptionManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    public PagedIterable<TenantIdDescription> list() {
        PagedIterable<TenantIdDescriptionInner> inner = this.serviceClient().list();
        return Utils.mapPage(inner, inner1 -> new TenantIdDescriptionImpl(inner1, this.manager()));
    }

    public PagedIterable<TenantIdDescription> list(Context context) {
        PagedIterable<TenantIdDescriptionInner> inner = this.serviceClient().list(context);
        return Utils.mapPage(inner, inner1 -> new TenantIdDescriptionImpl(inner1, this.manager()));
    }

    private TenantsClient serviceClient() {
        return this.innerClient;
    }

    private com.azure.resourcemanager.subscription.SubscriptionManager manager() {
        return this.serviceManager;
    }
}
