// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.subscription.models;

import com.azure.core.http.rest.Response;
import com.azure.core.util.Context;

/** Resource collection API of Alias. */
public interface Alias {
    /**
     * Create Alias Subscription.
     *
     * @param aliasName Name for this subscription creation request also known as alias. Note that this is not the same
     *     as subscription name and this doesn’t have any other lifecycle need beyond the request for subscription
     *     creation.
     * @param body The parameters required to create a new subscription.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return subscription Information with the alias.
     */
    PutAliasResponse create(String aliasName, PutAliasRequest body);

    /**
     * Create Alias Subscription.
     *
     * @param aliasName Name for this subscription creation request also known as alias. Note that this is not the same
     *     as subscription name and this doesn’t have any other lifecycle need beyond the request for subscription
     *     creation.
     * @param body The parameters required to create a new subscription.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return subscription Information with the alias.
     */
    PutAliasResponse create(String aliasName, PutAliasRequest body, Context context);

    /**
     * Get Alias Subscription.
     *
     * @param aliasName Name for this subscription creation request also known as alias. Note that this is not the same
     *     as subscription name and this doesn’t have any other lifecycle need beyond the request for subscription
     *     creation.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return alias Subscription along with {@link Response}.
     */
    Response<PutAliasResponse> getWithResponse(String aliasName, Context context);

    /**
     * Get Alias Subscription.
     *
     * @param aliasName Name for this subscription creation request also known as alias. Note that this is not the same
     *     as subscription name and this doesn’t have any other lifecycle need beyond the request for subscription
     *     creation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return alias Subscription.
     */
    PutAliasResponse get(String aliasName);

    /**
     * Delete Alias.
     *
     * @param aliasName Name for this subscription creation request also known as alias. Note that this is not the same
     *     as subscription name and this doesn’t have any other lifecycle need beyond the request for subscription
     *     creation.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response}.
     */
    Response<Void> deleteWithResponse(String aliasName, Context context);

    /**
     * Delete Alias.
     *
     * @param aliasName Name for this subscription creation request also known as alias. Note that this is not the same
     *     as subscription name and this doesn’t have any other lifecycle need beyond the request for subscription
     *     creation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    void delete(String aliasName);

    /**
     * Get Alias Subscription.
     *
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return alias Subscription along with {@link Response}.
     */
    Response<PutAliasListResult> listWithResponse(Context context);

    /**
     * Get Alias Subscription.
     *
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return alias Subscription.
     */
    PutAliasListResult list();
}
