// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.subscription.models;

import com.azure.resourcemanager.subscription.fluent.models.LocationInner;

/** An immutable client-side representation of Location. */
public interface Location {
    /**
     * Gets the id property: The fully qualified ID of the location. For example,
     * /subscriptions/00000000-0000-0000-0000-000000000000/locations/westus.
     *
     * @return the id value.
     */
    String id();

    /**
     * Gets the subscriptionId property: The subscription ID.
     *
     * @return the subscriptionId value.
     */
    String subscriptionId();

    /**
     * Gets the name property: The location name.
     *
     * @return the name value.
     */
    String name();

    /**
     * Gets the displayName property: The display name of the location.
     *
     * @return the displayName value.
     */
    String displayName();

    /**
     * Gets the latitude property: The latitude of the location.
     *
     * @return the latitude value.
     */
    String latitude();

    /**
     * Gets the longitude property: The longitude of the location.
     *
     * @return the longitude value.
     */
    String longitude();

    /**
     * Gets the inner com.azure.resourcemanager.subscription.fluent.models.LocationInner object.
     *
     * @return the inner object.
     */
    LocationInner innerModel();
}
