// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.subscription.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.fasterxml.jackson.annotation.JsonProperty;

/** The parameters required to create a new subscription. */
@Fluent
public final class PutAliasRequest {
    /*
     * Put alias request properties.
     */
    @JsonProperty(value = "properties", required = true)
    private PutAliasRequestProperties properties;

    /** Creates an instance of PutAliasRequest class. */
    public PutAliasRequest() {
    }

    /**
     * Get the properties property: Put alias request properties.
     *
     * @return the properties value.
     */
    public PutAliasRequestProperties properties() {
        return this.properties;
    }

    /**
     * Set the properties property: Put alias request properties.
     *
     * @param properties the properties value to set.
     * @return the PutAliasRequest object itself.
     */
    public PutAliasRequest withProperties(PutAliasRequestProperties properties) {
        this.properties = properties;
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (properties() == null) {
            throw LOGGER
                .logExceptionAsError(
                    new IllegalArgumentException("Missing required property properties in model PutAliasRequest"));
        } else {
            properties().validate();
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(PutAliasRequest.class);
}
