// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.subscription.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonProperty;

/** Put subscription properties. */
@Fluent
public final class PutAliasRequestProperties {
    /*
     * The friendly name of the subscription.
     */
    @JsonProperty(value = "displayName")
    private String displayName;

    /*
     * The workload type of the subscription. It can be either Production or DevTest.
     */
    @JsonProperty(value = "workload")
    private Workload workload;

    /*
     * Determines whether subscription is fieldLed, partnerLed or LegacyEA
     */
    @JsonProperty(value = "billingScope")
    private String billingScope;

    /*
     * This parameter can be used to create alias for existing subscription Id
     */
    @JsonProperty(value = "subscriptionId")
    private String subscriptionId;

    /*
     * Reseller ID, basically MPN Id
     */
    @JsonProperty(value = "resellerId")
    private String resellerId;

    /** Creates an instance of PutAliasRequestProperties class. */
    public PutAliasRequestProperties() {
    }

    /**
     * Get the displayName property: The friendly name of the subscription.
     *
     * @return the displayName value.
     */
    public String displayName() {
        return this.displayName;
    }

    /**
     * Set the displayName property: The friendly name of the subscription.
     *
     * @param displayName the displayName value to set.
     * @return the PutAliasRequestProperties object itself.
     */
    public PutAliasRequestProperties withDisplayName(String displayName) {
        this.displayName = displayName;
        return this;
    }

    /**
     * Get the workload property: The workload type of the subscription. It can be either Production or DevTest.
     *
     * @return the workload value.
     */
    public Workload workload() {
        return this.workload;
    }

    /**
     * Set the workload property: The workload type of the subscription. It can be either Production or DevTest.
     *
     * @param workload the workload value to set.
     * @return the PutAliasRequestProperties object itself.
     */
    public PutAliasRequestProperties withWorkload(Workload workload) {
        this.workload = workload;
        return this;
    }

    /**
     * Get the billingScope property: Determines whether subscription is fieldLed, partnerLed or LegacyEA.
     *
     * @return the billingScope value.
     */
    public String billingScope() {
        return this.billingScope;
    }

    /**
     * Set the billingScope property: Determines whether subscription is fieldLed, partnerLed or LegacyEA.
     *
     * @param billingScope the billingScope value to set.
     * @return the PutAliasRequestProperties object itself.
     */
    public PutAliasRequestProperties withBillingScope(String billingScope) {
        this.billingScope = billingScope;
        return this;
    }

    /**
     * Get the subscriptionId property: This parameter can be used to create alias for existing subscription Id.
     *
     * @return the subscriptionId value.
     */
    public String subscriptionId() {
        return this.subscriptionId;
    }

    /**
     * Set the subscriptionId property: This parameter can be used to create alias for existing subscription Id.
     *
     * @param subscriptionId the subscriptionId value to set.
     * @return the PutAliasRequestProperties object itself.
     */
    public PutAliasRequestProperties withSubscriptionId(String subscriptionId) {
        this.subscriptionId = subscriptionId;
        return this;
    }

    /**
     * Get the resellerId property: Reseller ID, basically MPN Id.
     *
     * @return the resellerId value.
     */
    public String resellerId() {
        return this.resellerId;
    }

    /**
     * Set the resellerId property: Reseller ID, basically MPN Id.
     *
     * @param resellerId the resellerId value to set.
     * @return the PutAliasRequestProperties object itself.
     */
    public PutAliasRequestProperties withResellerId(String resellerId) {
        this.resellerId = resellerId;
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }
}
