// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.subscription.models;

import com.azure.resourcemanager.subscription.fluent.models.TenantIdDescriptionInner;

/** An immutable client-side representation of TenantIdDescription. */
public interface TenantIdDescription {
    /**
     * Gets the id property: The fully qualified ID of the tenant. For example,
     * /tenants/00000000-0000-0000-0000-000000000000.
     *
     * @return the id value.
     */
    String id();

    /**
     * Gets the tenantId property: The tenant ID. For example, 00000000-0000-0000-0000-000000000000.
     *
     * @return the tenantId value.
     */
    String tenantId();

    /**
     * Gets the tenantCategory property: The category of the tenant. Possible values are
     * TenantCategoryHome,TenantCategoryProjectedBy,TenantCategoryManagedBy.
     *
     * @return the tenantCategory value.
     */
    String tenantCategory();

    /**
     * Gets the country property: The country/region name of the address for the tenant.
     *
     * @return the country value.
     */
    String country();

    /**
     * Gets the countryCode property: The Country/region abbreviation for the tenant.
     *
     * @return the countryCode value.
     */
    String countryCode();

    /**
     * Gets the displayName property: The display name of the tenant.
     *
     * @return the displayName value.
     */
    String displayName();

    /**
     * Gets the domains property: The list of domains for the tenant.
     *
     * @return the domains value.
     */
    String domains();

    /**
     * Gets the defaultDomain property: The default domain for the tenant.
     *
     * @return the defaultDomain value.
     */
    String defaultDomain();

    /**
     * Gets the tenantType property: The tenant type. Only available for Home tenant category.
     *
     * @return the tenantType value.
     */
    String tenantType();

    /**
     * Gets the inner com.azure.resourcemanager.subscription.fluent.models.TenantIdDescriptionInner object.
     *
     * @return the inner object.
     */
    TenantIdDescriptionInner innerModel();
}
